/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.model;

import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramModelBase;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramNodeModel;
import org.eclipse.sapphire.ui.swt.gef.model.ImageModel;
import org.eclipse.sapphire.ui.swt.gef.model.LineShapeModel;
import org.eclipse.sapphire.ui.swt.gef.model.RectangleModel;
import org.eclipse.sapphire.ui.swt.gef.model.ShapeFactoryModel;
import org.eclipse.sapphire.ui.swt.gef.model.TextModel;
import org.eclipse.sapphire.ui.swt.gef.model.ValidationMarkerModel;
import org.eclipse.sapphire.ui.swt.gef.presentation.ImagePresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.LineShapePresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.RectanglePresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.ShapeFactoryPresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.ShapePresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.TextPresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.ValidationMarkerPresentation;

public class ShapeModel
extends DiagramModelBase {
    private DiagramNodeModel nodeModel;
    private ShapeModel parent;
    private ShapePresentation shapePresentation;
    public static final String SHAPE_START_EDITING = "SHAPE_START_EDITING";

    public ShapeModel(DiagramNodeModel nodeModel, ShapeModel parent, ShapePresentation shapePresentation) {
        this.nodeModel = nodeModel;
        this.parent = parent;
        this.shapePresentation = shapePresentation;
    }

    @Override
    public SapphirePart getSapphirePart() {
        return this.shapePresentation.part();
    }

    public ShapePresentation getShapePresentation() {
        return this.shapePresentation;
    }

    public ShapeModel getParent() {
        return this.parent;
    }

    public DiagramNodeModel getNodeModel() {
        return this.nodeModel;
    }

    public final <T> T nearest(Class<T> partType) {
        if (partType.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (this.parent != null) {
            return this.parent.nearest(partType);
        }
        return null;
    }

    public static final class ShapeModelFactory {
        public static ShapeModel createShapeModel(DiagramNodeModel nodeModel, ShapeModel parent, ShapePresentation shapePresentation) {
            ShapeModel childModel = null;
            if (shapePresentation instanceof TextPresentation) {
                childModel = new TextModel(nodeModel, parent, (TextPresentation)shapePresentation);
            } else if (shapePresentation instanceof ImagePresentation) {
                childModel = new ImageModel(nodeModel, parent, (ImagePresentation)shapePresentation);
            } else if (shapePresentation instanceof LineShapePresentation) {
                childModel = new LineShapeModel(nodeModel, parent, (LineShapePresentation)shapePresentation);
            } else if (shapePresentation instanceof ValidationMarkerPresentation) {
                childModel = new ValidationMarkerModel(nodeModel, parent, (ValidationMarkerPresentation)shapePresentation);
            } else if (shapePresentation instanceof RectanglePresentation) {
                childModel = new RectangleModel(nodeModel, parent, (RectanglePresentation)shapePresentation);
            } else if (shapePresentation instanceof ShapeFactoryPresentation) {
                childModel = new ShapeFactoryModel(nodeModel, parent, (ShapeFactoryPresentation)shapePresentation);
            }
            return childModel;
        }
    }
}

