/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.sapphire.ui.swt.gef.figures.FigureUtil;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramResourceCache;
import org.eclipse.sapphire.ui.swt.gef.presentation.LineShapePresentation;
import org.eclipse.swt.graphics.Color;

public class OrthogonalLineFigure
extends Shape {
    private LineShapePresentation linePresentation;
    private DiagramResourceCache resourceCache;

    public OrthogonalLineFigure(LineShapePresentation linePresentation, DiagramResourceCache resourceCache) {
        this.linePresentation = linePresentation;
        this.resourceCache = resourceCache;
    }

    protected void fillShape(Graphics graphics) {
    }

    protected void outlineShape(Graphics graphics) {
        int oldLineWidth = graphics.getLineWidth();
        Color oldColor = graphics.getForegroundColor();
        int oldLineStyle = graphics.getLineStyle();
        Rectangle bbox = this.getBounds();
        int weight = this.linePresentation.getWeight();
        graphics.setLineWidth(weight);
        graphics.setForegroundColor(this.resourceCache.getColor(this.linePresentation.getColor()));
        graphics.setLineStyle(FigureUtil.convertLineStyle(this.linePresentation.getStyle()));
        int inset = Math.max(1, weight / 2);
        if (this.linePresentation.isHorizontal()) {
            graphics.drawLine(bbox.x + inset, bbox.y, bbox.x + bbox.width - inset - inset, bbox.y);
        } else {
            graphics.drawLine(bbox.x + inset, bbox.y, bbox.x + inset, bbox.y + bbox.height);
        }
        graphics.setLineWidth(oldLineWidth);
        graphics.setForegroundColor(oldColor);
        graphics.setLineStyle(oldLineStyle);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.linePresentation.isHorizontal()) {
            return new Dimension(wHint, this.linePresentation.getWeight());
        }
        return new Dimension(this.linePresentation.getWeight(), hHint);
    }

    public Dimension getMaximumSize() {
        if (this.linePresentation.isHorizontal()) {
            return new Dimension(Integer.MAX_VALUE, this.linePresentation.getWeight());
        }
        return new Dimension(this.linePresentation.getWeight(), Integer.MAX_VALUE);
    }
}

