/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.KeyHandler;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.def.KeyBindingBehavior;
import org.eclipse.sapphire.ui.def.SapphireKeySequence;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.editor.ShapePart;
import org.eclipse.sapphire.ui.forms.swt.SapphireActionPresentation;
import org.eclipse.sapphire.ui.forms.swt.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.swt.gef.DiagramKeyboardActionPresentation;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramEditor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Display;

public class SapphireDiagramKeyHandler
extends KeyHandler {
    private KeyHandler parent;
    private SapphireDiagramEditor diagramEditor;
    private List<ISapphirePart> sapphireParts;
    private ISapphirePart sapphirePart;
    private String actionContext;
    private String hiddenContext;
    private GraphicalEditPart editPart;
    private SapphireActionGroup tempActions;
    private SapphireActionGroup hiddenActions;
    private SapphireActionPresentationManager actionPresentationManager;
    private SapphireActionPresentationManager hiddenActionPresentationManager;
    private DiagramKeyboardActionPresentation actionPresentation;
    private DiagramKeyboardActionPresentation hiddenActionPresentation;

    public SapphireDiagramKeyHandler(SapphireDiagramEditor diagramEditor, List<ISapphirePart> sapphireParts) {
        this.diagramEditor = diagramEditor;
        this.sapphireParts = new ArrayList<ISapphirePart>();
        this.sapphireParts.addAll(sapphireParts);
        this.hiddenContext = null;
        if (sapphireParts.size() == 1) {
            this.sapphirePart = sapphireParts.get(0);
            if (this.sapphirePart instanceof SapphireDiagramEditorPagePart) {
                this.actionContext = "Sapphire.Diagram.Editor";
            } else if (this.sapphirePart instanceof DiagramNodePart) {
                this.actionContext = "Sapphire.Diagram.Node";
                this.hiddenContext = "Sapphire.Diagram.Node.Hidden";
            } else if (this.sapphirePart instanceof ShapePart) {
                this.actionContext = "Sapphire.Diagram.Node.Shape";
                this.hiddenContext = "Sapphire.Diagram.Node.Shape.Hidden";
            } else if (this.sapphirePart instanceof DiagramConnectionPart) {
                this.actionContext = "Sapphire.Diagram.Connection";
                this.hiddenContext = "Sapphire.Diagram.Connection.Hidden";
            }
            this.editPart = diagramEditor.getSelectedEditParts().get(0);
        } else if (sapphireParts.size() > 1) {
            this.actionContext = "Sapphire.Diagram.MultipleParts";
            this.sapphirePart = this.diagramEditor.getPart();
        }
    }

    public boolean keyPressed(KeyEvent event) {
        SapphireActionPresentationManager manager = this.getManager();
        SapphireActionGroup localGroupOfActions = manager.getActionGroup();
        if (!(this.sapphirePart instanceof DiagramConnectionPart) || ((DiagramConnectionPart)this.sapphirePart).removable()) {
            if (this.handleKeyEvent(event, manager, localGroupOfActions, false)) {
                return true;
            }
            if (this.hiddenActions != null && this.handleKeyEvent(event, this.getHiddenManager(), this.hiddenActions, false)) {
                return true;
            }
        }
        if (this.sapphireParts.size() == 1) {
            ISapphirePart part = this.sapphirePart.parent();
            while (part != null) {
                String mainActionContext = part.getMainActionContext();
                if (mainActionContext != null) {
                    SapphireActionGroup groupOfActions = part.getActions(mainActionContext);
                    if (this.handleKeyEvent(event, this.getManager(), groupOfActions, true)) {
                        return true;
                    }
                }
                part = part.parent();
            }
            return this.parent != null && this.parent.keyPressed(event);
        }
        return false;
    }

    private boolean handleKeyEvent(KeyEvent event, final SapphireActionPresentationManager manager, SapphireActionGroup groupOfActions, boolean onlyPropagatedKeyBindings) {
        for (SapphireAction action : groupOfActions.getActions()) {
            SapphireKeySequence keySequence;
            if (!action.hasActiveHandlers() || onlyPropagatedKeyBindings && action.getKeyBindingBehavior() != KeyBindingBehavior.PROPAGATED || (keySequence = action.getKeyBinding()) == null) continue;
            int expectedStateMask = 0;
            for (SapphireKeySequence.Modifier modifier : keySequence.getModifiers()) {
                if (modifier == SapphireKeySequence.Modifier.SHIFT) {
                    expectedStateMask |= 0x20000;
                    continue;
                }
                if (modifier == SapphireKeySequence.Modifier.ALT) {
                    expectedStateMask |= 0x10000;
                    continue;
                }
                if (modifier != SapphireKeySequence.Modifier.CONTROL) continue;
                expectedStateMask |= 0x40000;
            }
            if (event.stateMask != expectedStateMask || event.keyCode != keySequence.getKeyCode()) continue;
            List handlers = action.getActiveHandlers();
            if (handlers.size() == 1) {
                final SapphireActionHandler handler = (SapphireActionHandler)handlers.get(0);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        handler.execute(manager.context());
                    }
                };
                Display.getDefault().asyncExec(runnable);
            } else {
                for (SapphireActionPresentation presentation : manager.getPresentations()) {
                    if (presentation.displayActionHandlerChoice(action)) break;
                }
            }
            return true;
        }
        return false;
    }

    public KeyHandler setParent(KeyHandler parent) {
        this.parent = parent;
        return this;
    }

    public void dispose() {
        if (this.actionPresentationManager != null) {
            this.actionPresentationManager.dispose();
            this.actionPresentationManager = null;
        }
        if (this.hiddenActionPresentationManager != null) {
            this.hiddenActionPresentationManager.dispose();
            this.hiddenActionPresentationManager = null;
        }
    }

    private SapphireActionPresentationManager getManager() {
        if (this.actionPresentationManager == null) {
            this.initActions();
        }
        return this.actionPresentationManager;
    }

    private SapphireActionPresentationManager getHiddenManager() {
        if (this.actionPresentationManager == null) {
            this.initActions();
        }
        return this.hiddenActionPresentationManager;
    }

    private void initActions() {
        this.tempActions = this.sapphirePart.getActions(this.actionContext);
        this.actionPresentationManager = new SapphireActionPresentationManager((Presentation)this.diagramEditor.getDiagramPresentation(), this.tempActions);
        this.actionPresentation = new DiagramKeyboardActionPresentation(this.actionPresentationManager, this.diagramEditor, this.editPart);
        this.actionPresentation.render();
        if (this.hiddenContext != null) {
            this.hiddenActions = this.sapphirePart.getActions(this.hiddenContext);
            this.hiddenActionPresentationManager = new SapphireActionPresentationManager((Presentation)this.diagramEditor.getDiagramPresentation(), this.hiddenActions);
            this.hiddenActionPresentation = new DiagramKeyboardActionPresentation(this.hiddenActionPresentationManager, this.diagramEditor, this.editPart);
            this.hiddenActionPresentation.render();
        }
    }
}

