/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.wizards;

import oracle.eclipse.tools.common.ui.wizards.EnhancedWizardPage;
import oracle.eclipse.tools.common.ui.wizards.ValidationException;
import oracle.eclipse.tools.common.util.ResourceLoader;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ProjectWizardPage
extends EnhancedWizardPage {
    private static final String _WIDGET_NAME = "name";
    private static final String _WIDGET = String.valueOf(ProjectWizardPage.class.getName()) + ".";
    public static final String WIDGET_PROJECT_NAME = String.valueOf(_WIDGET) + "projectName";
    public static final String WIDGET_USE_SINGLE_FOLDER = String.valueOf(_WIDGET) + "useSingleFolder";
    public static final String WIDGET_USE_SEPARATE_FOLDERS = String.valueOf(_WIDGET) + "useSeparateFolders";
    private static final ResourceLoader _resourceLoader = new ResourceLoader(ProjectWizardPage.class);
    private Text _projectNameField;
    private boolean _useDefaultLocation = true;
    private boolean _useSeparateFolders;
    private Text _projectLocationField;

    public ProjectWizardPage(String pageName) {
        super(pageName);
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        this._useSeparateFolders = store.getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects");
    }

    private String getProjectName() {
        return this._projectNameField.getText().trim();
    }

    public IProject getProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    private String getProjectLocationString() {
        return this._projectLocationField.getText().trim();
    }

    public IPath getProjectLocation() {
        if (this._useDefaultLocation) {
            return null;
        }
        return new Path(this.getProjectLocationString());
    }

    public IFolder getSourceFolder() {
        if (!this._useSeparateFolders) {
            return null;
        }
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        return this.getProject().getFolder(store.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersSrcName"));
    }

    public IFolder getOutputFolder() {
        if (!this._useSeparateFolders) {
            return null;
        }
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        return this.getProject().getFolder(store.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName"));
    }

    public void createControl(Composite parent) {
        Composite group = new Composite(parent, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(1808));
        this.createNameGroup(group);
        this.createLocationGroup(group);
        this.createLayoutGroup(group);
        this.setControl((Control)group);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this._projectNameField.setFocus();
        }
    }

    private void createNameGroup(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        Label projectNameLabel = new Label(group, 0);
        projectNameLabel.setText(_resourceLoader.resource("projectName", new Object[0]));
        this._projectNameField = new Text(group, 2048);
        this._projectNameField.setData(_WIDGET_NAME, (Object)WIDGET_PROJECT_NAME);
        GridData data = new GridData(768);
        this._projectNameField.setLayoutData((Object)data);
        this._projectNameField.setText("");
        this._projectNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectWizardPage.this.changedPage();
            }
        });
    }

    private void createLocationGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        group.setText(_resourceLoader.resource("projectLocation", new Object[0]));
        final Button useDefaultLocationButton = new Button((Composite)group, 131104);
        useDefaultLocationButton.setText(_resourceLoader.resource("useDefaultLocation", new Object[0]));
        useDefaultLocationButton.setSelection(this._useDefaultLocation);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        useDefaultLocationButton.setLayoutData((Object)gd);
        final Label projectLocationLabel = new Label((Composite)group, 0);
        projectLocationLabel.setText(_resourceLoader.resource("projectDirectory", new Object[0]));
        projectLocationLabel.setEnabled(!this._useDefaultLocation);
        this._projectLocationField = new Text((Composite)group, 2052);
        this._projectLocationField.setText("");
        this._projectLocationField.setEnabled(!this._useDefaultLocation);
        gd = new GridData(768);
        this._projectLocationField.setLayoutData((Object)gd);
        this._projectLocationField.setEditable(true);
        this._projectLocationField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectWizardPage.this.changedPage();
            }
        });
        final Button browseButton = new Button((Composite)group, 8);
        browseButton.setText(_resourceLoader.resource("browseDirectories", new Object[0]));
        browseButton.setEnabled(!this._useDefaultLocation);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectWizardPage.this.pressedBrowse();
            }
        });
        useDefaultLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectWizardPage.this._useDefaultLocation = useDefaultLocationButton.getSelection();
                boolean enabled = !ProjectWizardPage.this._useDefaultLocation;
                browseButton.setEnabled(enabled);
                ProjectWizardPage.this._projectLocationField.setEnabled(enabled);
                projectLocationLabel.setEnabled(enabled);
                ProjectWizardPage.this.changedPage();
            }
        });
    }

    private void createLayoutGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        group.setText(_resourceLoader.resource("projectLayout", new Object[0]));
        Button useSingleFolderButton = new Button((Composite)group, 16);
        useSingleFolderButton.setData(_WIDGET_NAME, (Object)WIDGET_USE_SINGLE_FOLDER);
        useSingleFolderButton.setText(_resourceLoader.resource("useSingleFolder", new Object[0]));
        useSingleFolderButton.setSelection(!this._useSeparateFolders);
        GridData gd = new GridData();
        useSingleFolderButton.setLayoutData((Object)gd);
        Button useSeparateFoldersButton = new Button((Composite)group, 16);
        useSeparateFoldersButton.setData(_WIDGET_NAME, (Object)WIDGET_USE_SEPARATE_FOLDERS);
        useSeparateFoldersButton.setText(_resourceLoader.resource("useSeparateFolders", new Object[0]));
        useSeparateFoldersButton.setSelection(this._useSeparateFolders);
        gd = new GridData();
        useSeparateFoldersButton.setLayoutData((Object)gd);
        useSingleFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectWizardPage.this._useSeparateFolders = false;
                ProjectWizardPage.this.changedPage();
            }
        });
        useSeparateFoldersButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectWizardPage.this._useSeparateFolders = true;
                ProjectWizardPage.this.changedPage();
            }
        });
    }

    private void changedPage() {
        this.setPageStatus();
    }

    private void pressedBrowse() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setFilterPath(this.getProjectLocationString());
        dialog.setMessage(_resourceLoader.resource("directoryDialog.description", new Object[0]));
        dialog.setText(_resourceLoader.resource("directoryDialog.title", new Object[0]));
        String pathText = dialog.open();
        if (pathText == null) {
            return;
        }
        this._projectLocationField.setText(pathText);
    }

    @Override
    protected void validatePage() throws ValidationException {
        String projectName = this.getProjectName();
        IStatus status = ResourcesPlugin.getWorkspace().validateName(projectName, 4);
        if (!status.isOK()) {
            throw ValidationException.forStatus(status);
        }
        IProject project = this.getProject();
        if (project.exists()) {
            throw new ValidationException(_resourceLoader.resource("error.projectExists", new Object[0]));
        }
        IPath location = this.getProjectLocation();
        if (location != null && !(status = ResourcesPlugin.getWorkspace().validateProjectLocation(project, location)).isOK()) {
            throw ValidationException.forStatus(status);
        }
    }
}

