/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.wizards;

import java.util.ArrayList;
import oracle.eclipse.tools.common.ui.wizards.AbstractContainerSelectionGroup;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownComposite;

public class ContainerSelectionGroup
extends AbstractContainerSelectionGroup {
    private static final String _WIDGET_NAME = "name";
    private static final String _WIDGET = String.valueOf(ContainerSelectionGroup.class.getName()) + ".";
    public static final String WIDGET_CONTAINER_NAME = String.valueOf(_WIDGET) + "containerName";
    public static final String WIDGET_CONTAINER_TREE = String.valueOf(_WIDGET) + "containerTree";
    private boolean _allowNewContainerName = true;
    private IContentProvider _containerContentProvider;
    private Text _containerNameField;
    TreeViewer _treeViewer;
    private static final String DEFAULT_MSG_NEW_ALLOWED = IDEWorkbenchMessages.ContainerGroup_message;
    private static final String DEFAULT_MSG_SELECT_ONLY = IDEWorkbenchMessages.ContainerGroup_selectFolder;
    private static final int SIZING_SELECTION_PANE_WIDTH = 320;
    private static final int SIZING_SELECTION_PANE_HEIGHT = 300;

    public ContainerSelectionGroup(Composite parent, boolean allowNewContainerName, String message, IContentProvider containerContentProvider) {
        this(parent, allowNewContainerName, message, containerContentProvider, 300);
    }

    public ContainerSelectionGroup(Composite parent, boolean allowNewContainerName, String message, IContentProvider containerContentProvider, int heightHint) {
        super(parent);
        this._allowNewContainerName = allowNewContainerName;
        this._containerContentProvider = containerContentProvider;
        if (message != null) {
            this.createContents(message, heightHint);
        } else if (allowNewContainerName) {
            this.createContents(DEFAULT_MSG_NEW_ALLOWED, heightHint);
        } else {
            this.createContents(DEFAULT_MSG_SELECT_ONLY, heightHint);
        }
    }

    @Override
    public void containerSelectionChanged(IContainer container) {
        if (this._allowNewContainerName) {
            if (container == null) {
                this._containerNameField.setText("");
            } else {
                this._containerNameField.setText(container.getFullPath().makeRelative().toString());
            }
        }
        super.containerSelectionChanged(container);
    }

    public void createContents(String message) {
        this.createContents(message, 300);
    }

    public void createContents(String message, int heightHint) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        Label label = new Label((Composite)this, 64);
        label.setText(message);
        label.setFont(this.getFont());
        if (this._allowNewContainerName) {
            this._containerNameField = new Text((Composite)this, 2052);
            this._containerNameField.setData(_WIDGET_NAME, (Object)WIDGET_CONTAINER_NAME);
            this._containerNameField.setLayoutData((Object)new GridData(768));
            this._containerNameField.setFont(this.getFont());
        } else {
            new Label((Composite)this, 0);
        }
        this.createTreeViewer(heightHint);
        Dialog.applyDialogFont((Control)this);
    }

    public void addContainerNameModifyListener(Listener listener) {
        this._containerNameField.addListener(24, listener);
    }

    protected void createTreeViewer(int heightHint) {
        DrillDownComposite drillDown = new DrillDownComposite((Composite)this, 2048);
        GridData spec = new GridData(4, 4, true, true);
        spec.widthHint = 320;
        spec.heightHint = heightHint;
        drillDown.setLayoutData((Object)spec);
        this._treeViewer = new TreeViewer((Composite)drillDown, 0);
        drillDown.setChildTree(this._treeViewer);
        this._treeViewer.setContentProvider(this._containerContentProvider);
        this._treeViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this._treeViewer.setSorter(new ViewerSorter());
        this._treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ContainerSelectionGroup.this.containerSelectionChanged((IContainer)selection.getFirstElement());
            }
        });
        this._treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (ContainerSelectionGroup.this._treeViewer.getExpandedState(item)) {
                        ContainerSelectionGroup.this._treeViewer.collapseToLevel(item, 1);
                    } else {
                        ContainerSelectionGroup.this._treeViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        this._treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        this._treeViewer.getTree().setData(_WIDGET_NAME, (Object)WIDGET_CONTAINER_TREE);
    }

    @Override
    public IPath getContainerFullPath() {
        if (this._allowNewContainerName) {
            String pathName = this._containerNameField.getText();
            if (pathName == null || pathName.length() < 1) {
                return null;
            }
            return new Path(pathName).makeAbsolute();
        }
        return super.getContainerFullPath();
    }

    @Override
    public void setInitialFocus() {
        if (this._allowNewContainerName) {
            this._containerNameField.setFocus();
        } else {
            this._treeViewer.getTree().setFocus();
        }
    }

    @Override
    public void setSelectedContainer(IContainer container) {
        super.setSelectedContainer(container);
        ArrayList<IContainer> itemsToExpand = new ArrayList<IContainer>();
        IContainer parent = container.getParent();
        while (parent != null) {
            itemsToExpand.add(0, parent);
            parent = parent.getParent();
        }
        this._treeViewer.setExpandedElements(itemsToExpand.toArray());
        this._treeViewer.setSelection((ISelection)new StructuredSelection((Object)container), true);
    }
}

