/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.wizards;

import java.util.ArrayList;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public abstract class ContainerContentProvider
implements ITreeContentProvider {
    private boolean _showClosedProjects = false;
    private boolean _showDerivedResources = false;

    protected abstract boolean isValidProject(IProject var1);

    protected boolean isValidContainer(IContainer container) {
        return true;
    }

    public void showClosedProjects(boolean valid) {
        this._showClosedProjects = valid;
    }

    public void showDerivedResources(boolean valid) {
        this._showDerivedResources = valid;
    }

    public void dispose() {
    }

    public Object[] getChildren(Object element) {
        IContainer container;
        if (element instanceof IWorkspace) {
            IProject[] allProjects = ((IWorkspace)element).getRoot().getProjects();
            ArrayList<IProject> accessibleProjects = new ArrayList<IProject>();
            int i = 0;
            while (i < allProjects.length) {
                IProject project = allProjects[i];
                if (!project.isDerived() || this._showDerivedResources) {
                    if (project.isOpen()) {
                        if (this.isValidProject(project)) {
                            accessibleProjects.add(allProjects[i]);
                        }
                    } else if (this._showClosedProjects) {
                        accessibleProjects.add(allProjects[i]);
                    }
                }
                ++i;
            }
            return accessibleProjects.toArray();
        }
        if (element instanceof IContainer && (container = (IContainer)element).isAccessible()) {
            try {
                ArrayList<IResource> children = new ArrayList<IResource>();
                IResource[] members = container.members();
                int i = 0;
                while (i < members.length) {
                    IResource member = members[i];
                    if ((!member.isDerived() || this._showDerivedResources) && member.getType() != 1 && this.isValidContainer((IContainer)member)) {
                        children.add(member);
                    }
                    ++i;
                }
                return children.toArray();
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.ui", (CoreException)e);
            }
        }
        return new Object[0];
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public Object getParent(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

