/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.widgets;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public final class ProjectsDisplayPanel
extends Composite {
    private final ContentProvider contentProvider;
    private final TableViewer projectTable;
    final Set<IProject> projects = new HashSet<IProject>();

    public ProjectsDisplayPanel(Composite parent, int style) {
        super(parent, style);
        this.projectTable = new TableViewer((Composite)this, 2820);
        this.projectTable.getControl().setBackground(Display.getDefault().getSystemColor(22));
        this.projectTable.getControl().setEnabled(true);
        this.projectTable.getControl().setLayoutData((Object)new GridData(1808));
        this.contentProvider = new ContentProvider();
        this.projectTable.setContentProvider((IContentProvider)this.contentProvider);
        this.projectTable.setLabelProvider((IBaseLabelProvider)new ProjectLabelDecorator((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), this.projectTable.getControl()));
        this.projectTable.setSorter((ViewerSorter)new Sorter());
    }

    public Set<IProject> getProjects() {
        return this.projects;
    }

    public void setProjects(Set<IProject> projects) {
        this.projects.clear();
        this.projects.addAll(projects);
        this.projectTable.setInput(this.projects);
    }

    private static final class ContentProvider
    implements IStructuredContentProvider {
        private Set<IProject> model = null;

        private ContentProvider() {
        }

        public synchronized void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.model = (Set)newInput;
            this.rebuildModel();
        }

        public void dispose() {
        }

        private boolean rebuildModel() {
            if (this.model == null) {
                return true;
            }
            for (IProject project : this.model) {
                if (project.isAccessible()) continue;
                this.model.remove(project);
            }
            return true;
        }

        public Object[] getElements(Object inputElement) {
            return this.model.toArray();
        }
    }

    private static final class ProjectLabelDecorator
    extends DecoratingLabelProvider
    implements ITableFontProvider {
        private static final String TEXT_PADDING = " ";
        private final Font projectFont;

        public ProjectLabelDecorator(ILabelProvider provider, ILabelDecorator decorator, Control control) {
            super(provider, decorator);
            FontData projectFontData = new FontData("Arial", 8, 1);
            this.projectFont = new Font((Device)control.getDisplay(), projectFontData);
        }

        public String getText(Object element) {
            if (element instanceof IProject) {
                return TEXT_PADDING + super.getText(element);
            }
            return super.getText(element);
        }

        public Font getFont(Object element, int index) {
            if (element instanceof IProject) {
                return this.projectFont;
            }
            return null;
        }

        public void dispose() {
            if (this.projectFont != null) {
                this.projectFont.dispose();
            }
            super.dispose();
        }
    }

    private static final class Sorter
    extends ViewerSorter {
        private Sorter() {
        }

        public int compare(Viewer viewer, Object a, Object b) {
            String aName = ((IProject)a).getName();
            String bName = ((IProject)b).getName();
            return aName.compareTo(bName);
        }
    }
}

