/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.widgets;

import java.io.File;
import oracle.eclipse.tools.common.ui.widgets.AbstractComposite;
import oracle.eclipse.tools.common.ui.widgets.IModelBindingWidget;
import oracle.eclipse.tools.common.util.IModel;
import oracle.eclipse.tools.common.util.ObjectUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractFileBrowserTextField
extends AbstractComposite
implements IModelBindingWidget {
    protected final Text text;
    private final Button button;

    public AbstractFileBrowserTextField(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.text = new Text((Composite)this, 2048);
        this.text.setLayoutData((Object)new GridData(768));
        this.button = new Button((Composite)this, 0);
        this.button.setText(Resources.browseLabel);
        this.setButtonLayoutData(this.button);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractFileBrowserTextField.this.browseButtonPressed();
            }
        });
    }

    public File getFile() {
        if (this.text.getText().trim().length() == 0) {
            return null;
        }
        return new File(this.text.getText());
    }

    public void setFile(File f) {
        if (!ObjectUtil.equals((Object)f, (Object)this.getFile())) {
            if (f == null) {
                this.text.setText("");
            } else {
                this.text.setText(f.getPath());
            }
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.text.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }

    public void addModifyListener(ModifyListener listener) {
        this.text.addModifyListener(listener);
    }

    @Override
    public void bind(final IModel model, final String property) {
        final IModel.IListener modelListener = new IModel.IListener(){

            public void propertyChanged(String prop, Object oldValue, Object newValue) {
                AbstractFileBrowserTextField.this.setFile((File)newValue);
            }
        };
        model.addListener(modelListener, new String[]{property});
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                model.setProperty(property, (Object)AbstractFileBrowserTextField.this.getFile());
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                model.removeListener(modelListener);
            }
        });
        this.setFile((File)model.getProperty(property));
    }

    protected abstract void browseButtonPressed();

    private static final class Resources
    extends NLS {
        public static String browseLabel;

        static {
            Resources.initializeMessages((String)AbstractFileBrowserTextField.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

