/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.util.otn;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import oracle.eclipse.tools.common.otn.OTNDownloadUtil;
import oracle.eclipse.tools.common.ui.internal.CommonUiPlugin;
import oracle.eclipse.tools.common.ui.util.otn.BrowserLauncher;
import oracle.eclipse.tools.common.ui.util.otn.Resources;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.osgi.util.tracker.ServiceTracker;

public class OTNDownloadUIUtil {
    private static Proxy getProxy(String fileUrl) {
        try (ServiceTracker proxyTracker = null;){
            proxyTracker = new ServiceTracker(CommonUiPlugin.getDefault().getBundle().getBundleContext(), IProxyService.class.getName(), null);
            proxyTracker.open();
            IProxyService service = (IProxyService)proxyTracker.getService();
            IProxyData[] proxyDataForHost = service.select(new URI(fileUrl));
            if (proxyDataForHost != null && proxyDataForHost.length > 0 && proxyDataForHost[0].getHost() != null && !proxyDataForHost[0].getHost().trim().isEmpty()) {
                String proxyHost = proxyDataForHost[0].getHost();
                int proxyPort = proxyDataForHost[0].getPort();
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
                return proxy;
            }
        }
        return null;
    }

    private static HttpURLConnection handleOTNLogin(final String fileUrl, String username, String passwd) throws IOException {
        boolean retry = true;
        while (retry) {
            HttpURLConnection urlConnection = OTNDownloadUtil.getConnection((String)fileUrl, (Proxy)OTNDownloadUIUtil.getProxy(fileUrl), (String)username, (String)passwd);
            if (urlConnection == null) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), WorkbenchMessages.Error, null, Resources.errInvalidLoginInfo, 1, new String[]{IDialogConstants.OK_LABEL}, 0){

                            protected int getShellStyle() {
                                return super.getShellStyle() | 0x10000000;
                            }

                            protected Control createCustomArea(Composite parent) {
                                Composite comp = new Composite(parent, 0);
                                comp.setLayout((Layout)new GridLayout(2, false));
                                Label label1 = new Label(comp, 0);
                                label1.setText(Resources.checkUsernamePassword);
                                GridData gd = new GridData();
                                gd.horizontalIndent = 40;
                                gd.horizontalSpan = 2;
                                label1.setLayoutData((Object)gd);
                                Label label2 = new Label(comp, 0);
                                label2.setText(Resources.tryDownload);
                                gd = new GridData();
                                gd.horizontalIndent = 40;
                                label2.setLayoutData((Object)gd);
                                Hyperlink link = new Hyperlink(comp, 64);
                                link.setUnderlined(true);
                                link.setForeground(new Color((Device)Display.getDefault(), 0, 0, 255));
                                link.setText(Resources.OTN);
                                link.setToolTipText(fileUrl);
                                gd = new GridData();
                                link.setLayoutData((Object)gd);
                                link.addHyperlinkListener(new IHyperlinkListener(){

                                    public void linkExited(HyperlinkEvent arg0) {
                                    }

                                    public void linkEntered(HyperlinkEvent arg0) {
                                    }

                                    public void linkActivated(HyperlinkEvent arg0) {
                                        try {
                                            BrowserLauncher.displayURL("http://www.oracle.com/technetwork/developer-tools/adf/downloads/index.html");
                                        }
                                        catch (IOException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                });
                                return link;
                            }
                        };
                        dialog.open();
                    }
                });
                retry = true;
                continue;
            }
            return urlConnection;
        }
        String msg = String.valueOf(Resources.errorConnectToOTN) + " " + fileUrl;
        throw new IOException(msg);
    }

    public static boolean download(String fileUrl, File destFile, String userName, String passwd, IProgressMonitor monitor) throws IOException, InterruptedException {
        String totalSizeString;
        monitor.setTaskName(Resources.progressConnecting);
        HttpURLConnection urlConnection = null;
        urlConnection = OTNDownloadUIUtil.handleOTNLogin(fileUrl, userName, passwd);
        if (urlConnection == null) {
            return false;
        }
        monitor.worked(20);
        int size = urlConnection.getContentLength();
        if (size == -1) {
            totalSizeString = null;
            monitor.beginTask(Resources.progressTransferStarted, -1);
        } else {
            totalSizeString = OTNDownloadUIUtil.formatByteCount(size);
            monitor.beginTask(Resources.progressTransferStarted, size);
        }
        if (destFile.exists() && destFile.length() == (long)size) {
            return true;
        }
        InputStream in = null;
        FileOutputStream out = null;
        try {
            in = urlConnection.getInputStream();
            out = new FileOutputStream(destFile);
            byte[] buffer = new byte[16384];
            int count = 0;
            int bytesTransfered = 0;
            long t0 = System.currentTimeMillis();
            while ((count = in.read(buffer)) != -1) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                out.write(buffer, 0, count);
                monitor.worked(count);
                String msg = OTNDownloadUIUtil.formatDownloadProgressMessage(bytesTransfered += count, totalSizeString);
                long t1 = System.currentTimeMillis();
                if (t1 - t0 > 0L) {
                    msg = String.valueOf(msg) + " (" + (long)bytesTransfered / (t1 - t0) + "KB/Sec)";
                }
                monitor.setTaskName(msg);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            monitor.done();
        }
        return true;
    }

    private static String formatByteCount(int byteCount) {
        if (byteCount < 0x100000) {
            return String.format("%3.0f KB", Float.valueOf((float)byteCount / 1024.0f));
        }
        return String.format("%.1f MB", Float.valueOf((float)byteCount / 1048576.0f));
    }

    private static String formatDownloadProgressMessage(int bytesTransfered, String totalSizeString) {
        String bytesTransferedString = OTNDownloadUIUtil.formatByteCount(bytesTransfered);
        if (totalSizeString != null) {
            return NLS.bind((String)Resources.progressTransferred, (Object)bytesTransferedString, (Object)totalSizeString);
        }
        return NLS.bind((String)Resources.progressTransferredNoTotalSize, (Object)bytesTransferedString);
    }

    static class LoginInfo {
        public String userName;
        public String password;

        LoginInfo() {
        }
    }
}

