/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.util;

import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ThreadUtil {
    private static final String INDENT = "     ";

    public static void ensureRunOnUIThread(Runnable runnable) {
        if (ThreadUtil.isMainDisplayThread()) {
            runnable.run();
        } else {
            PlatformUI.getWorkbench().getDisplay().syncExec(runnable);
        }
    }

    public static boolean isMainDisplayThread() {
        return Display.findDisplay((Thread)Thread.currentThread()) == Display.getDefault();
    }

    public static void logThreadDump(Plugin callingPlugin) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("\n");
        buffer.append("\n");
        buffer.append("===========================================================\n");
        buffer.append("=         T H R E A D    D U M P    B E G I N S           =\n");
        buffer.append("===========================================================\n");
        buffer.append("\n");
        ThreadUtil.generateThreadDump(buffer);
        buffer.append("\n");
        buffer.append("===========================================================\n");
        buffer.append("=      T H R E A D    D U M P    C O M P L E T E          =\n");
        buffer.append("===========================================================\n");
        buffer.append("\n");
        LoggingService.logError((Plugin)callingPlugin, (String)buffer.toString());
    }

    public static void generateThreadDump(StringBuilder buffer) {
        Set<Thread> allThreads = ThreadUtil.getAllThreads();
        for (Thread nextThread : allThreads) {
            ThreadUtil.generateThreadDump(nextThread, nextThread.getStackTrace(), buffer);
        }
    }

    public static void generateThreadDump(Thread t, StackTraceElement[] frames, StringBuilder buffer) {
        buffer.append(t.toString());
        buffer.append("\n");
        StackTraceElement[] stackTraceElementArray = frames;
        int n = frames.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement nextElement = stackTraceElementArray[n2];
            buffer.append(INDENT);
            if (nextElement == frames[0]) {
                buffer.append("   ");
            } else {
                buffer.append("at ");
            }
            buffer.append(nextElement.toString());
            buffer.append("\n");
            ++n2;
        }
        buffer.append("\n");
    }

    public static Set<Thread> getAllThreads() {
        ThreadGroup root = Thread.currentThread().getThreadGroup().getParent();
        while (root.getParent() != null) {
            root = root.getParent();
        }
        HashSet<Thread> allThreads = new HashSet<Thread>();
        ThreadUtil.getAllThreads(root, 0, allThreads);
        return allThreads;
    }

    private static void getAllThreads(ThreadGroup group, int level, Set<Thread> io_allThreads) {
        int numThreads = group.activeCount();
        Thread[] threads = new Thread[numThreads * 2];
        numThreads = group.enumerate(threads, false);
        int i = 0;
        while (i < numThreads) {
            io_allThreads.add(threads[i]);
            ++i;
        }
        int numGroups = group.activeGroupCount();
        ThreadGroup[] groups = new ThreadGroup[numGroups * 2];
        numGroups = group.enumerate(groups, false);
        int i2 = 0;
        while (i2 < numGroups) {
            ThreadUtil.getAllThreads(groups[i2], level + 1, io_allThreads);
            ++i2;
        }
    }
}

