/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.util;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class ImageUtil {
    private static Map<String, Image> images = new HashMap<String, Image>();

    public static Image getImageFromPlugin(String attributeName, IConfigurationElement declaring) {
        Image image = null;
        String icon = attributeName == null ? declaring.getValue() : declaring.getAttribute(attributeName);
        if (icon != null) {
            String pluginId = declaring.getDeclaringExtension().getNamespaceIdentifier();
            Bundle bundle = Platform.getBundle((String)pluginId);
            image = ImageUtil.getImageFromPlugin(bundle, (IPath)new Path(icon));
        }
        return image;
    }

    public static Image getImageFromPlugin(Plugin sourcePlugin, IPath imagePath) {
        Bundle bundle = sourcePlugin.getBundle();
        return ImageUtil.getImageFromPlugin(bundle, imagePath);
    }

    private static Image getImageFromPlugin(Bundle sourceBundle, IPath imagePath) {
        Image image;
        block4: {
            ImageDescriptor descriptor = null;
            String fullPath = String.valueOf(sourceBundle.getSymbolicName()) + "." + imagePath.toString();
            image = images.get(fullPath);
            if (image != null) {
                return image;
            }
            URL iconDir = FileLocator.find((Bundle)sourceBundle, (IPath)imagePath, null);
            if (iconDir == null) {
                String message = String.format("Failed to locate image <%s> in bundle <%s>", imagePath == null ? null : imagePath.toString(), sourceBundle.getBundleId());
                LoggingService.logError((String)"oracle.eclipse.tools.common.ui", (String)message);
                return null;
            }
            try {
                URL localURL = FileLocator.toFileURL((URL)iconDir);
                descriptor = ImageDescriptor.createFromURL((URL)localURL);
                image = descriptor.createImage();
                images.put(fullPath, image);
            }
            catch (IOException ioe) {
                String message = "Failed to open icon <" + imagePath + "> in bundle : " + sourceBundle.getBundleId();
                LoggingService.logException((String)"oracle.eclipse.tools.common.ui", (Throwable)ioe, (String)message);
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        return image;
    }
}

