/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import oracle.eclipse.tools.common.ui.util.ThreadUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.util.system.RuntimeResponse;
import oracle.eclipse.tools.common.util.system.RuntimeResponseImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class ExecHelper
extends oracle.eclipse.tools.common.util.system.ExecHelper {
    public static RuntimeResponse syncExec(String[] cmd, File dir, String name) throws IOException {
        return ExecHelper.syncExec(cmd, dir, name, 0L);
    }

    public static RuntimeResponse syncExec(String[] cmd, File dir, String name, long timeoutMilli) throws IOException {
        return ExecHelper.syncExec(cmd, dir, name, true, timeoutMilli);
    }

    public static RuntimeResponse syncExec(String[] cmd, File dir, String name, boolean redirectErrorStream, long timeoutMilli) throws IOException {
        RuntimeResponseImpl response = (RuntimeResponseImpl)ExecHelper.async((String[])cmd, (File)dir, (String)name, (boolean)redirectErrorStream);
        return ExecHelper.syncExec((RuntimeResponse)response, timeoutMilli);
    }

    public static RuntimeResponse syncExec(RuntimeResponse response) {
        return ExecHelper.syncExec(response, 0L);
    }

    public static RuntimeResponse syncExec(final RuntimeResponse response, final long timeoutMilli) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                long waitMilli = timeoutMilli;
                long start = System.currentTimeMillis();
                while (!response.isDone()) {
                    try {
                        response.join(waitMilli);
                    }
                    catch (InterruptedException interruptedException) {}
                    waitMilli = ExecHelper.timeLeft(start, timeoutMilli);
                    if (waitMilli < 0L) break;
                }
            }
        };
        if (ThreadUtil.isMainDisplayThread() && PlatformUI.isWorkbenchRunning()) {
            IProgressService ps = PlatformUI.getWorkbench().getProgressService();
            try {
                ps.busyCursorWhile(runnable);
            }
            catch (Exception e) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.ui", (Throwable)e);
            }
        } else {
            try {
                runnable.run(null);
            }
            catch (Exception e) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.ui", (Throwable)e);
            }
        }
        return response;
    }

    private static long timeLeft(long start, long duration) {
        if (duration == 0L) {
            return 0L;
        }
        if (duration < 0L) {
            return duration;
        }
        long elapsed = System.currentTimeMillis() - start;
        if (elapsed >= duration) {
            return -1L;
        }
        return duration - elapsed + 1L;
    }
}

