/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.systemresources;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public abstract class ResourceKey<T extends Resource> {
    private static Map<ResourceKey<? extends Resource>, Resource> _resources = new HashMap<ResourceKey<? extends Resource>, Resource>();

    static {
        ResourceKey.getDisplay().disposeExec(new Runnable(){

            @Override
            public void run() {
                for (Resource r : _resources.values()) {
                    if (r == null || r.isDisposed()) continue;
                    try {
                        r.dispose();
                    }
                    catch (Throwable throwable) {}
                }
            }
        });
    }

    protected synchronized T getResource(ResourceKey<T> key) {
        assert (key != null);
        Object resource = _resources.get(key);
        if (resource == null || resource.isDisposed()) {
            resource = key.getNewResource();
            _resources.put((ResourceKey<? extends Resource>)key, (Resource)resource);
        }
        return (T)resource;
    }

    protected abstract T getNewResource();

    protected static Display getDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }
}

