/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.selection;

import oracle.eclipse.tools.common.ui.selection.IContainerSelectionListener;
import oracle.eclipse.tools.common.util.ResourceLoader;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownComposite;

public class ContainerSelectionGroup
extends Composite {
    private static final ResourceLoader _resourceLoader = new ResourceLoader(ContainerSelectionGroup.class);
    private ITreeContentProvider _containerModel;
    private Text _containerNameField;
    private String _lastKnownPathText;
    private DrillDownComposite _drillDown;
    private TreeViewer _treeViewer;
    private IContainerSelectionListener _selectionListener;

    public ContainerSelectionGroup(Composite parent, ITreeContentProvider containerModel, IContainerSelectionListener selectionListener, int style) {
        super(parent, style);
        this._containerModel = containerModel;
        this._selectionListener = selectionListener;
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 768;
        this.setLayout((Layout)fillLayout);
        Composite mainPanel = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        mainPanel.setLayout((Layout)layout);
        Label label = new Label(mainPanel, 64);
        label.setText(_resourceLoader.resource("label.selectFolder", new Object[0]));
        this._containerNameField = new Text(mainPanel, 2052);
        this._containerNameField.setLayoutData((Object)new GridData(768));
        this._containerNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String containerText = ContainerSelectionGroup.this._containerNameField.getText();
                ContainerSelectionGroup.this._lastKnownPathText = containerText;
                Path containerPath = new Path(containerText);
                ContainerSelectionGroup.this._selectionListener.containerSelected((IPath)containerPath);
            }
        });
        this._drillDown = new DrillDownComposite(mainPanel, 2048);
        GridData gd = new GridData(4, 4, true, true);
        this._drillDown.setLayoutData((Object)gd);
        this._treeViewer = new TreeViewer((Composite)this._drillDown, 0);
        this._drillDown.setChildTree(this._treeViewer);
        this._treeViewer.setContentProvider((IContentProvider)this._containerModel);
        this._treeViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this._treeViewer.setSorter(new ViewerSorter());
        this._treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                IContainer selectedContainer = (IContainer)selection.getFirstElement();
                IPath selectedPath = selectedContainer == null ? null : selectedContainer.getFullPath();
                ContainerSelectionGroup.this.containerSelectionChanged(selectedPath);
            }
        });
        this._treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (ContainerSelectionGroup.this._treeViewer.getExpandedState(item)) {
                        ContainerSelectionGroup.this._treeViewer.collapseToLevel(item, 1);
                    } else {
                        ContainerSelectionGroup.this._treeViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        this._treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
    }

    public void containerSelectionChanged(IPath containerPath) {
        String containerName = "";
        if (containerPath != null) {
            containerName = containerPath.toPortableString();
        }
        this._containerNameField.setText(containerName);
        this._selectionListener.containerSelected(containerPath);
    }

    public IPath getSelectedContainerPath() {
        String pathText = this._lastKnownPathText;
        if (!this._containerNameField.isDisposed()) {
            pathText = this._containerNameField.getText();
        }
        Path returnPath = new Path(pathText);
        returnPath = returnPath.makeAbsolute();
        return returnPath.removeTrailingSeparator();
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this._containerNameField.setEnabled(enable);
        this._drillDown.setEnabled(enable);
    }

    public void setExpandedElements(Object[] elements) {
        if (elements != null) {
            this._treeViewer.setExpandedElements(elements);
            if (elements.length > 0) {
                this._treeViewer.reveal(elements[0]);
            }
        }
    }

    public boolean setFocus() {
        this._containerNameField.setFocus();
        return true;
    }

    public void setSelectedContainer(IContainer container) {
        assert (container != null);
        this._containerNameField.setText(container.getFullPath().toPortableString());
        this._lastKnownPathText = container.getFullPath().toPortableString();
        this._treeViewer.setSelection((ISelection)new StructuredSelection((Object)container), true);
    }
}

