/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.eclipse.tools.common.ui.preferences.PreferencePageSection;
import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.common.util.PluginUtil;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class ExtensiblePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String EXTENSION_POINT = "extensiblePreferencePages";
    private static final String EL_CONTRIBUTIONS = "contributions";
    private static final String EL_SECTION = "section";
    private static final String ATTR_PAGE = "page";
    private static final String ATTR_CLASS = "class";
    private final String id;
    private final List<PreferencePageSection> sections;

    protected ExtensiblePreferencePage(String id) {
        this.id = id;
        this.sections = new ArrayList<PreferencePageSection>();
        for (IConfigurationElement el : PluginUtil.getTopLevelElements((Collection)PluginUtil.findExtensions((String)"oracle.eclipse.tools.common.ui", (String)EXTENSION_POINT))) {
            if (!el.getName().equals(EL_CONTRIBUTIONS)) continue;
            String pluginId = el.getContributor().getName();
            try {
                String pageId = PluginUtil.findRequiredAttribute((IConfigurationElement)el, (String)ATTR_PAGE);
                if (!pageId.equals(this.id)) continue;
                IConfigurationElement[] iConfigurationElementArray = el.getChildren();
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String clname;
                    PreferencePageSection section;
                    IConfigurationElement elChild = iConfigurationElementArray[n2];
                    if (elChild.getName().equals(EL_SECTION) && (section = (PreferencePageSection)PluginUtil.instantiate((String)pluginId, (String)(clname = PluginUtil.findRequiredAttribute((IConfigurationElement)elChild, (String)ATTR_CLASS)), PreferencePageSection.class)) != null) {
                        this.sections.add(section);
                    }
                    ++n2;
                }
            }
            catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
        }
    }

    public boolean isValid() {
        for (PreferencePageSection section : this.sections) {
            if (section.validate().getSeverity() != 4) continue;
            return false;
        }
        return true;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)SwtUtil.gdfill());
        composite.setLayout((Layout)SwtUtil.glayout(1, 0, 10));
        for (PreferencePageSection section : this.sections) {
            Control sectionControl = section.createContents(composite);
            sectionControl.setLayoutData((Object)SwtUtil.gdhfill());
        }
        return composite;
    }

    public boolean performOk() {
        for (PreferencePageSection section : this.sections) {
            if (section.performOk()) continue;
            return false;
        }
        return true;
    }

    public boolean performCancel() {
        for (PreferencePageSection section : this.sections) {
            if (section.performCancel()) continue;
            return false;
        }
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        for (PreferencePageSection section : this.sections) {
            section.performDefaults();
        }
    }

    public void init(IWorkbench workbench) {
    }
}

