/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.dialogs;

import oracle.eclipse.tools.common.ui.dialogs.IToggleValue;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class ToggleValueFieldEditor
extends FieldEditor {
    private Combo _selector;
    private final IToggleValue _preferenceDefault;
    private final String _widgetNamePrefix;
    private static final String DATA_NAME = "name";

    public ToggleValueFieldEditor(String preferenceName, IToggleValue preferenceDefault, String labelText, Composite parent) {
        this.init(preferenceName, labelText);
        this._preferenceDefault = preferenceDefault;
        this._widgetNamePrefix = preferenceDefault.getTypeID();
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label label = new Label(parent, 64);
        label.setText(this.getLabelText());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gd);
        Combo selector = this.getSelectorControl(parent);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        selector.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this._selector != null) {
            String toggleValue = this.getPreferenceStore().getString(this.getPreferenceName());
            if (toggleValue == null || toggleValue.length() == 0) {
                toggleValue = this._preferenceDefault.toString();
            }
            IToggleValue value = this._preferenceDefault.parse(toggleValue);
            this._selector.select(value.toComboIndex());
        }
    }

    protected void doLoadDefault() {
        if (this._selector != null) {
            this._selector.select(this._preferenceDefault.toComboIndex());
        }
        this.setPresentsDefaultValue(false);
    }

    protected void doStore() {
        int selected = this._selector.getSelectionIndex();
        IToggleValue newValue = this._preferenceDefault.parseComboIndex(selected);
        this.getPreferenceStore().setValue(this.getPreferenceName(), newValue.toString());
    }

    public final int getNumberOfControls() {
        return 2;
    }

    public Combo getSelectorControl(Composite parent) {
        if (this._selector == null) {
            IToggleValue[] values;
            this._selector = new Combo(parent, 12);
            this._selector.setData(DATA_NAME, (Object)(String.valueOf(this._widgetNamePrefix) + this.getPreferenceName()));
            IToggleValue[] iToggleValueArray = values = this._preferenceDefault.allValues();
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                IToggleValue nextValue = iToggleValueArray[n2];
                this._selector.add(nextValue.toDisplayString(), nextValue.toComboIndex());
                ++n2;
            }
        } else {
            this.checkParent((Control)this._selector, parent);
        }
        return this._selector;
    }
}

