/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.dialogs;

import org.eclipse.core.internal.commands.util.Util;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class StatusDialog
extends Dialog {
    private String _title;
    private IStatus _status;
    private Label _statusMessageImage;
    private Label _statusMessageText;
    private Composite _buttonBar;

    public StatusDialog(String title) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.setShellStyle(65648);
        this._title = title;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this._title != null) {
            shell.setText(this._title);
        }
    }

    public int open() {
        this.validate();
        return super.open();
    }

    protected abstract void validate();

    protected Control createButtonBar(Composite parent) {
        this._buttonBar = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        this._buttonBar.setLayout((Layout)layout);
        this._buttonBar.setLayoutData((Object)new GridData(770));
        this._statusMessageImage = new Label(this._buttonBar, 0);
        this._statusMessageImage.setSize(30, 30);
        GridData imageData = new GridData(32);
        imageData.minimumWidth = 150;
        this._statusMessageImage.setLayoutData((Object)imageData);
        this._statusMessageText = new Label(this._buttonBar, 64);
        this._statusMessageText.setLayoutData((Object)new GridData(768));
        Dialog.applyDialogFont((Control)this._statusMessageText);
        super.createButtonBar(this._buttonBar);
        return this._buttonBar;
    }

    public IStatus getStatus() {
        return this._status;
    }

    public void setStatus(IStatus status) {
        boolean hasNewMessage;
        this._status = status;
        Image newImage = StatusDialog.getImage(status);
        boolean hasNewImage = !Util.equals((Object)newImage, (Object)this._statusMessageImage.getImage());
        String newMessage = status != null ? status.getMessage() : "";
        boolean bl = hasNewMessage = !Util.equals((Object)newMessage, (Object)this._statusMessageText.getText());
        if (hasNewImage) {
            this._statusMessageImage.setImage(newImage);
        }
        if (hasNewMessage) {
            this._statusMessageText.setText(newMessage);
        }
        if (hasNewMessage || hasNewImage) {
            this._buttonBar.getParent().layout();
            this._buttonBar.layout();
        }
        Button okButton = this.getButton(0);
        assert (okButton != null) : "null okButton";
        okButton.setEnabled(status == null);
    }

    public static IStatus makeStatus(IStatus oldStatus, String message) {
        return StatusDialog.makeStatus(oldStatus.getSeverity(), message);
    }

    public static IStatus makeInfoStatus(String message) {
        return StatusDialog.makeStatus(1, message);
    }

    public static IStatus makeWarningStatus(String message) {
        return StatusDialog.makeStatus(2, message);
    }

    public static IStatus makeErrorStatus(String message) {
        return StatusDialog.makeStatus(4, message);
    }

    public static IStatus makeStatus(int severity, String message) {
        assert (message != null) : "null status message";
        return new Status(severity, "oracle.eclipse.tools.common.ui", 0, message, null);
    }

    private static Image getImage(IStatus status) {
        String imageName = null;
        if (status != null) {
            if (status.matches(4)) {
                imageName = "IMG_OBJS_ERROR_TSK";
            } else if (status.matches(2)) {
                imageName = "IMG_OBJS_WARN_TSK";
            }
        }
        return imageName == null ? null : StatusDialog.getWorkbenchImage(imageName);
    }

    private static Image getWorkbenchImage(String imageName) {
        return PlatformUI.getWorkbench().getSharedImages().getImage(imageName);
    }
}

