/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.dialogs;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.NewPackageCreationWizard;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class PackageSelectionDialog
extends ElementListSelectionDialog {
    IPackageFragmentRoot packageFragmentRoot = null;

    public PackageSelectionDialog(Shell parent, IPackageFragmentRoot packRoot) {
        super(parent, (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        this.setTitle(J2EEUIMessages.PACKAGE_SELECTION_DIALOG_TITLE);
        this.setMessage(J2EEUIMessages.PACKAGE_SELECTION_DIALOG_DESC);
        this.setEmptyListMessage(J2EEUIMessages.PACKAGE_SELECTION_DIALOG_MSG_NONE);
        this.setPackageFragmentRoot(packRoot);
    }

    private void setPackageFragmentRoot(IPackageFragmentRoot packageFragmentRoot) {
        this.packageFragmentRoot = packageFragmentRoot;
        this.setElements(this.getJavaElements());
    }

    protected Control createDialogArea(Composite parent) {
        Control contents = super.createDialogArea(parent);
        this.createCreatePackageLink(parent);
        this.refreshList();
        return contents;
    }

    protected Link createCreatePackageLink(Composite parent) {
        Link link = new Link(parent, 0);
        GridData data = new GridData(32);
        data.horizontalIndent = 10;
        data.widthHint = 200;
        link.setLayoutData((Object)data);
        link.setText("<a>New Java Package</a>");
        link.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                NewPackageCreationWizard wizard = new NewPackageCreationWizard();
                wizard.init(JavaPlugin.getDefault().getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)PackageSelectionDialog.this.packageFragmentRoot));
                WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
                dialog.create();
                int ret = dialog.open();
                if (ret == 0) {
                    PackageSelectionDialog.this.refreshList();
                    IJavaElement newPackage = wizard.getCreatedElement();
                    PackageSelectionDialog.this.setSelection(new Object[]{newPackage});
                }
            }
        });
        return link;
    }

    private void refreshList() {
        this.setListElements(this.getJavaElements());
    }

    private IJavaElement[] getJavaElements() {
        if (this.packageFragmentRoot == null) {
            return new IJavaElement[0];
        }
        try {
            IJavaProject javaProj = this.packageFragmentRoot.getJavaProject();
            IPackageFragmentRoot[] roots = javaProj.getPackageFragmentRoots();
            IPackageFragmentRoot packRoot = roots[0];
            if (packRoot == null) {
                return new IJavaElement[0];
            }
            IJavaElement[] packages = null;
            try {
                packages = packRoot.getChildren();
            }
            catch (JavaModelException javaModelException) {}
            if (packages == null) {
                packages = new IJavaElement[]{};
            }
            return packages;
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return new IJavaElement[0];
        }
    }
}

