/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.dialogs;

import java.io.File;
import java.util.Set;
import java.util.TreeSet;
import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.common.util.MutableReference;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public final class OverwriteFilesDialog
extends Dialog {
    private final Set<File> files;

    public static boolean show(Shell shell, Set<File> files) {
        TreeSet<File> sortedAndFiltered = new TreeSet<File>();
        for (File f : files) {
            if (!f.exists()) continue;
            sortedAndFiltered.add(f);
        }
        if (sortedAndFiltered.isEmpty()) {
            return true;
        }
        OverwriteFilesDialog dialog = new OverwriteFilesDialog(shell, sortedAndFiltered);
        return dialog.open() == 0;
    }

    private OverwriteFilesDialog(Shell shell, Set<File> files) {
        super(shell);
        this.files = files;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Resources.dialogTitle);
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7) * 3 / 2;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4) * 2;
        layout.makeColumnsEqualWidth = false;
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)SwtUtil.gdfill());
        composite.setLayout((Layout)layout);
        Image image = this.getQuestionImage();
        Label imageLabel = new Label(composite, 0);
        image.setBackground(imageLabel.getBackground());
        imageLabel.setImage(image);
        imageLabel.setLayoutData((Object)SwtUtil.valign(SwtUtil.vspan(SwtUtil.gd(), 2), 1));
        Label label = new Label(composite, 64);
        label.setLayoutData((Object)SwtUtil.gdhfill());
        label.setText(Resources.dialogMessage);
        List list = new List(composite, 2560);
        list.setLayoutData((Object)SwtUtil.gdhhint(SwtUtil.gdfill(), 100));
        for (File f : this.files) {
            list.add(f.getAbsolutePath());
        }
        return composite;
    }

    private Image getQuestionImage() {
        return this.getSwtImage(4);
    }

    private Image getSwtImage(final int imageID) {
        Shell shell = this.getShell();
        if (shell == null) {
            shell = this.getParentShell();
        }
        final Display display = shell == null ? Display.getCurrent() : shell.getDisplay();
        final MutableReference imageRef = new MutableReference();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                imageRef.set((Object)display.getSystemImage(imageID));
            }
        });
        return (Image)imageRef.get();
    }

    private static final class Resources
    extends NLS {
        public static String dialogTitle;
        public static String dialogMessage;

        static {
            Resources.initializeMessages((String)OverwriteFilesDialog.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

