/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.common.util.ResourceLoader;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ListShuttleDialog<T>
extends SelectionDialog {
    private static final ResourceLoader _resourceLoader = new ResourceLoader(ListShuttleDialog.class);
    private boolean _orderSelectedItems = true;
    private boolean _allowMoveAllItems = true;
    private String _availableItemsLabelText;
    private String _selectedItemsLabelText;
    private TableViewer _availableItemsViewer;
    private TableViewer _selectedItemsViewer;
    private List<T> _allItems;
    private final LinkedList<T> _selectedItems = new LinkedList();
    private IStructuredContentProvider _availableItemsContentProvider;
    private ILabelProvider _availableItemsLabelProvider;
    private IStructuredContentProvider _selectedItemsContentProvider;
    private ILabelProvider _selectedItemsLabelProvider;
    private Button _rightBtn;
    private Button _leftBtn;
    private Button _rightAllBtn;
    private Button _leftAllBtn;
    private Button _upBtn;
    private Button _downBtn;
    private Button _topBtn;
    private Button _bottomBtn;
    private ISelectionChangedListener _availabeItemsSelectionListener;
    private ISelectionChangedListener _selectedItemsSelectionListener;
    private SelectionListener _rightBtnSelectionListener;
    private SelectionListener _leftBtnSelectionListener;
    private SelectionListener _rightAllBtnSelectionListener;
    private SelectionListener _leftAllBtnSelectionListener;
    private SelectionListener _upBtnSelectionListener;
    private SelectionListener _downBtnSelectionListener;
    private SelectionListener _topBtnSelectionListener;
    private SelectionListener _bottomBtnSelectionListener;
    private IDoubleClickListener _availabeItemsDoubleClickListener;
    private IDoubleClickListener _selectedItemsDoubleClickListener;

    public ListShuttleDialog(Shell parentShell) {
        super(parentShell);
        this.init();
    }

    private void init() {
        this._availableItemsLabelText = _resourceLoader.resource("availableItemsLabel", new Object[0]);
        this._selectedItemsLabelText = _resourceLoader.resource("selectedItemsLabel", new Object[0]);
        this.createListeners();
    }

    protected String getAvailableItemsLabelText() {
        return this._availableItemsLabelText;
    }

    public void setAvailableItemsLabelText(String text) {
        this._availableItemsLabelText = text;
    }

    protected String getSelectedItemsLabelText() {
        return this._selectedItemsLabelText;
    }

    public void setSelectedItemsLabelText(String text) {
        this._selectedItemsLabelText = text;
    }

    public void setOrderSelectedItems(boolean orderSelected) {
        this._orderSelectedItems = orderSelected;
    }

    public void setAllowMoveAllItems(boolean allowMoveAll) {
        this._allowMoveAllItems = allowMoveAll;
    }

    public void setAllItemsInput(List<? extends T> input) {
        this._allItems = Collections.unmodifiableList(input);
    }

    public void setAvailableItemsContentProvider(IStructuredContentProvider sp) {
        this._availableItemsContentProvider = sp;
    }

    public void setAvailableItemsLabelProvider(ILabelProvider lp) {
        this._availableItemsLabelProvider = lp;
    }

    public void setInitiallySelectedItemsInput(List<? extends T> input) {
        this._selectedItems.clear();
        this._selectedItems.addAll(input);
    }

    public List<T> getSelectedItems() {
        return Collections.unmodifiableList(this._selectedItems);
    }

    public List<T> getAvailableItems() {
        LinkedList<T> newList = new LinkedList<T>(this._allItems);
        newList.removeAll(this._selectedItems);
        return Collections.unmodifiableList(newList);
    }

    public void setSelectedItemsContentProvider(IStructuredContentProvider sp) {
        this._selectedItemsContentProvider = sp;
    }

    public void setSelectedItemsLabelProvider(ILabelProvider lp) {
        this._selectedItemsLabelProvider = lp;
    }

    protected Control createDialogArea(Composite container) {
        Composite parent = (Composite)super.createDialogArea(container);
        GridLayout layout = new GridLayout(this._orderSelectedItems ? 4 : 3, false);
        parent.setLayout((Layout)layout);
        this.createAvailableItemsComposite(parent);
        this.createMoveItemsButtonComposite(parent);
        this.createSelectedItemsComposite(parent);
        if (this._orderSelectedItems) {
            this.createOrderSelectedItemsButtonComposite(parent);
        }
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = 280;
        data.minimumWidth = 520;
        parent.setLayoutData((Object)data);
        this.addListeners();
        this.resetButtonEnablement();
        return parent;
    }

    private void createAvailableItemsComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        composite.setLayout((Layout)layout);
        Label availableItemsLabel = new Label(composite, 16384);
        availableItemsLabel.setText(this.getAvailableItemsLabelText());
        GridData data = new GridData(16384, 0x1000000, false, false);
        availableItemsLabel.setLayoutData((Object)data);
        this._availableItemsViewer = new TableViewer(composite);
        if (this._availableItemsContentProvider != null) {
            this._availableItemsViewer.setContentProvider((IContentProvider)this._availableItemsContentProvider);
        }
        if (this._availableItemsLabelProvider != null) {
            this._availableItemsViewer.setLabelProvider((IBaseLabelProvider)this._availableItemsLabelProvider);
        }
        this._availableItemsViewer.setInput(this.getAvailableItems());
        this._availableItemsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ListShuttleDialog.this.handleAddSelected();
            }
        });
        data = new GridData(4, 4, true, true);
        Table table = this._availableItemsViewer.getTable();
        table.setLayoutData((Object)data);
        composite.setLayoutData((Object)data);
    }

    private void createSelectedItemsComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        composite.setLayout((Layout)layout);
        Label selectedItemsLabel = new Label(composite, 16384);
        selectedItemsLabel.setText(this.getSelectedItemsLabelText());
        GridData data = new GridData(16384, 0x1000000, false, false);
        selectedItemsLabel.setLayoutData((Object)data);
        this._selectedItemsViewer = new TableViewer(composite);
        if (this._selectedItemsContentProvider != null) {
            this._selectedItemsViewer.setContentProvider((IContentProvider)this._selectedItemsContentProvider);
        }
        if (this._selectedItemsLabelProvider != null) {
            this._selectedItemsViewer.setLabelProvider((IBaseLabelProvider)this._selectedItemsLabelProvider);
        }
        this._selectedItemsViewer.setInput(this._selectedItems);
        this._selectedItemsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ListShuttleDialog.this.handleRemoveSelected();
            }
        });
        this.setResult(this._selectedItems);
        data = new GridData(4, 4, true, true);
        Table table = this._selectedItemsViewer.getTable();
        table.setLayoutData((Object)data);
        composite.setLayoutData((Object)data);
    }

    private void createMoveItemsButtonComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this._rightBtn = new Button(composite, 8);
        this._rightBtn.setImage(CommonImages.createImage(CommonImages.DESC_BUTTON_MOVE_RIGHT));
        this._rightBtn.setToolTipText(_resourceLoader.resource("rightButtonToolTip", new Object[0]));
        GridData data = new GridData(4, 0x1000000, false, false);
        this._rightBtn.setLayoutData((Object)data);
        this._leftBtn = new Button(composite, 8);
        this._leftBtn.setImage(CommonImages.createImage(CommonImages.DESC_BUTTON_MOVE_LEFT));
        this._leftBtn.setToolTipText(_resourceLoader.resource("leftButtonToolTip", new Object[0]));
        this._leftBtn.setLayoutData((Object)data);
        if (this._allowMoveAllItems) {
            Label spacer = new Label(composite, 16384);
            spacer.setText("");
            spacer.setLayoutData((Object)data);
            this._rightAllBtn = new Button(composite, 8);
            this._rightAllBtn.setImage(CommonImages.createImage(CommonImages.DESC_BUTTON_MOVE_ALL_RIGHT));
            this._rightAllBtn.setToolTipText(_resourceLoader.resource("rightAllButtonToolTip", new Object[0]));
            this._rightAllBtn.setLayoutData((Object)data);
            this._leftAllBtn = new Button(composite, 8);
            this._leftAllBtn.setImage(CommonImages.createImage(CommonImages.DESC_BUTTON_MOVE_ALL_LEFT));
            this._leftAllBtn.setToolTipText(_resourceLoader.resource("leftAllButtonToolTip", new Object[0]));
            this._leftAllBtn.setLayoutData((Object)data);
        }
    }

    private void createOrderSelectedItemsButtonComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 0x1000000, false, false);
        this._topBtn = new Button(composite, 8);
        this._topBtn.setImage(CommonImages.createImage(CommonImages.DESC_BUTTON_MOVE_TO_TOP));
        this._topBtn.setToolTipText(_resourceLoader.resource("topButtonToolTip", new Object[0]));
        this._topBtn.setLayoutData((Object)data);
        this._upBtn = new Button(composite, 8);
        this._upBtn.setImage(CommonImages.createImage(CommonImages.DESC_BUTTON_MOVE_UP));
        this._upBtn.setToolTipText(_resourceLoader.resource("upButtonToolTip", new Object[0]));
        this._upBtn.setLayoutData((Object)data);
        Label spacer = new Label(composite, 16384);
        spacer.setText("");
        spacer.setLayoutData((Object)data);
        this._downBtn = new Button(composite, 8);
        this._downBtn.setImage(CommonImages.createImage(CommonImages.DESC_BUTTON_MOVE_DOWN));
        this._downBtn.setToolTipText(_resourceLoader.resource("downButtonToolTip", new Object[0]));
        this._downBtn.setLayoutData((Object)data);
        this._bottomBtn = new Button(composite, 8);
        this._bottomBtn.setImage(CommonImages.createImage(CommonImages.DESC_BUTTON_MOVE_TO_BOTTOM));
        this._bottomBtn.setToolTipText(_resourceLoader.resource("bottomButtonToolTip", new Object[0]));
        this._bottomBtn.setLayoutData((Object)data);
    }

    private void handleAddSelected() {
        IStructuredSelection selection = (IStructuredSelection)this._availableItemsViewer.getSelection();
        if (selection != null) {
            this.moveItemsToSelected(selection.toList());
        }
        this.resetButtonEnablement();
    }

    private void handleRemoveSelected() {
        IStructuredSelection selection = (IStructuredSelection)this._selectedItemsViewer.getSelection();
        if (selection != null) {
            this.removeItemsFromSelected(selection.toList());
        }
        this.resetButtonEnablement();
    }

    private void createListeners() {
        this._rightBtnSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ListShuttleDialog.this.handleAddSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this._leftBtnSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ListShuttleDialog.this.handleRemoveSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this._rightAllBtnSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List items = (List)ListShuttleDialog.this._availableItemsViewer.getInput();
                ListShuttleDialog.this.moveItemsToSelected(items);
                ListShuttleDialog.this.resetButtonEnablement();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this._leftAllBtnSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ListShuttleDialog.this.removeItemsFromSelected(ListShuttleDialog.this._selectedItems);
                ListShuttleDialog.this.resetButtonEnablement();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this._upBtnSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ListShuttleDialog.this._selectedItemsViewer.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    List itemsToMove = selection.toList();
                    if (!ListShuttleDialog.this._selectedItems.get(0).equals(itemsToMove.get(0))) {
                        ArrayList items = new ArrayList(ListShuttleDialog.this._selectedItems);
                        int i = 1;
                        while (i < items.size()) {
                            if (itemsToMove.contains(items.get(i))) {
                                Object item = ListShuttleDialog.this._selectedItems.remove(i);
                                ListShuttleDialog.this._selectedItems.add(i - 1, item);
                            }
                            ++i;
                        }
                        ListShuttleDialog.this._selectedItemsViewer.refresh();
                        ListShuttleDialog.this.setResult(ListShuttleDialog.this._selectedItems);
                    }
                }
                ListShuttleDialog.this.setOrderSelectedItemsButtonEnablement(selection);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this._downBtnSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ListShuttleDialog.this._selectedItemsViewer.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    List itemsToMove = selection.toList();
                    if (!ListShuttleDialog.this._selectedItems.get(ListShuttleDialog.this._selectedItems.size() - 1).equals(itemsToMove.get(itemsToMove.size() - 1))) {
                        ArrayList items = new ArrayList(ListShuttleDialog.this._selectedItems);
                        int i = items.size() - 2;
                        while (i >= 0) {
                            if (itemsToMove.contains(items.get(i))) {
                                Object item = ListShuttleDialog.this._selectedItems.remove(i);
                                ListShuttleDialog.this._selectedItems.add(i + 1, item);
                            }
                            --i;
                        }
                        ListShuttleDialog.this._selectedItemsViewer.refresh();
                        ListShuttleDialog.this.setResult(ListShuttleDialog.this._selectedItems);
                    }
                }
                ListShuttleDialog.this.setOrderSelectedItemsButtonEnablement(selection);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this._topBtnSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ListShuttleDialog.this._selectedItemsViewer.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    List itemsToMove = selection.toList();
                    if (!ListShuttleDialog.this._selectedItems.get(0).equals(itemsToMove.get(0))) {
                        ListShuttleDialog.this._selectedItems.removeAll(itemsToMove);
                        int i = itemsToMove.size() - 1;
                        while (i >= 0) {
                            ListShuttleDialog.this._selectedItems.addFirst(itemsToMove.get(i));
                            --i;
                        }
                        ListShuttleDialog.this._selectedItemsViewer.refresh();
                        ListShuttleDialog.this.setResult(ListShuttleDialog.this._selectedItems);
                    }
                }
                ListShuttleDialog.this.setOrderSelectedItemsButtonEnablement(selection);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this._bottomBtnSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ListShuttleDialog.this._selectedItemsViewer.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    List itemsToMove = selection.toList();
                    if (!ListShuttleDialog.this._selectedItems.get(ListShuttleDialog.this._selectedItems.size() - 1).equals(itemsToMove.get(itemsToMove.size() - 1))) {
                        ListShuttleDialog.this._selectedItems.removeAll(itemsToMove);
                        int i = 0;
                        while (i < itemsToMove.size()) {
                            ListShuttleDialog.this._selectedItems.addLast(itemsToMove.get(i));
                            ++i;
                        }
                        ListShuttleDialog.this._selectedItemsViewer.refresh();
                        ListShuttleDialog.this.setResult(ListShuttleDialog.this._selectedItems);
                    }
                }
                ListShuttleDialog.this.setOrderSelectedItemsButtonEnablement(selection);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this._availabeItemsSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                List items = (List)ListShuttleDialog.this._availableItemsViewer.getInput();
                if (items == null || items.isEmpty()) {
                    ListShuttleDialog.this._rightBtn.setEnabled(false);
                } else {
                    ListShuttleDialog.this._rightBtn.setEnabled(true);
                }
                ListShuttleDialog.this._leftBtn.setEnabled(false);
                ListShuttleDialog.this.setMoveAllItemsButtonEnablement();
                if (ListShuttleDialog.this._orderSelectedItems) {
                    ListShuttleDialog.this._upBtn.setEnabled(false);
                    ListShuttleDialog.this._downBtn.setEnabled(false);
                    ListShuttleDialog.this._topBtn.setEnabled(false);
                    ListShuttleDialog.this._bottomBtn.setEnabled(false);
                }
                ListShuttleDialog.this._selectedItemsViewer.removeSelectionChangedListener(ListShuttleDialog.this._selectedItemsSelectionListener);
                Table table = ListShuttleDialog.this._selectedItemsViewer.getTable();
                table.deselectAll();
                ListShuttleDialog.this._selectedItemsViewer.addSelectionChangedListener(ListShuttleDialog.this._selectedItemsSelectionListener);
            }
        };
        this._selectedItemsSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel;
                ListShuttleDialog.this._rightBtn.setEnabled(false);
                if (ListShuttleDialog.this._selectedItems.isEmpty()) {
                    ListShuttleDialog.this._leftBtn.setEnabled(false);
                } else {
                    ListShuttleDialog.this._leftBtn.setEnabled(true);
                }
                ListShuttleDialog.this.setMoveAllItemsButtonEnablement();
                if (ListShuttleDialog.this._orderSelectedItems && !(sel = event.getSelection()).isEmpty() && sel instanceof IStructuredSelection) {
                    ListShuttleDialog.this.setOrderSelectedItemsButtonEnablement((IStructuredSelection)sel);
                }
                ListShuttleDialog.this._availableItemsViewer.removeSelectionChangedListener(ListShuttleDialog.this._availabeItemsSelectionListener);
                Table table = ListShuttleDialog.this._availableItemsViewer.getTable();
                table.deselectAll();
                ListShuttleDialog.this._availableItemsViewer.addSelectionChangedListener(ListShuttleDialog.this._availabeItemsSelectionListener);
            }
        };
        this._availabeItemsDoubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ListShuttleDialog.this.handleAddSelected();
            }
        };
        this._selectedItemsDoubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ListShuttleDialog.this.handleRemoveSelected();
            }
        };
    }

    private void addListeners() {
        this._rightBtn.addSelectionListener(this._rightBtnSelectionListener);
        this._leftBtn.addSelectionListener(this._leftBtnSelectionListener);
        if (this._allowMoveAllItems) {
            this._rightAllBtn.addSelectionListener(this._rightAllBtnSelectionListener);
            this._leftAllBtn.addSelectionListener(this._leftAllBtnSelectionListener);
        }
        if (this._orderSelectedItems) {
            this._upBtn.addSelectionListener(this._upBtnSelectionListener);
            this._downBtn.addSelectionListener(this._downBtnSelectionListener);
            this._topBtn.addSelectionListener(this._topBtnSelectionListener);
            this._bottomBtn.addSelectionListener(this._bottomBtnSelectionListener);
        }
        this._availableItemsViewer.addSelectionChangedListener(this._availabeItemsSelectionListener);
        this._availableItemsViewer.addDoubleClickListener(this._availabeItemsDoubleClickListener);
        this._selectedItemsViewer.addSelectionChangedListener(this._selectedItemsSelectionListener);
        this._selectedItemsViewer.addDoubleClickListener(this._selectedItemsDoubleClickListener);
    }

    private void moveItemsToSelected(List<T> items) {
        if (items == null || items.isEmpty()) {
            return;
        }
        this._selectedItems.addAll(items);
        this._selectedItemsViewer.refresh();
        this.setResult(this._selectedItems);
        this._availableItemsViewer.setInput(this.getAvailableItems());
        this._availableItemsViewer.refresh();
    }

    private void removeItemsFromSelected(List<T> items) {
        if (items == null || items.isEmpty()) {
            return;
        }
        this._selectedItems.removeAll(items);
        this._selectedItemsViewer.refresh();
        this.setResult(this._selectedItems);
        this._availableItemsViewer.setInput(this.getAvailableItems());
        this._availableItemsViewer.refresh();
    }

    protected void resetButtonEnablement() {
        this._rightBtn.setEnabled(false);
        this._leftBtn.setEnabled(false);
        this.setMoveAllItemsButtonEnablement();
        if (this._orderSelectedItems) {
            this._upBtn.setEnabled(false);
            this._downBtn.setEnabled(false);
            this._topBtn.setEnabled(false);
            this._bottomBtn.setEnabled(false);
        }
    }

    protected void setMoveAllItemsButtonEnablement() {
        if (this._allowMoveAllItems) {
            List availableItems = (List)this._availableItemsViewer.getInput();
            this._rightAllBtn.setEnabled(!availableItems.isEmpty());
            this._leftAllBtn.setEnabled(!this._selectedItems.isEmpty());
        }
    }

    protected void setOrderSelectedItemsButtonEnablement(IStructuredSelection selection) {
        if (this._orderSelectedItems && selection != null) {
            if (selection.size() == 0) {
                this._upBtn.setEnabled(false);
                this._topBtn.setEnabled(false);
                this._downBtn.setEnabled(false);
                this._bottomBtn.setEnabled(false);
            } else {
                List items = selection.toList();
                if (this._selectedItems.get(0).equals(items.get(0))) {
                    this._upBtn.setEnabled(false);
                    this._topBtn.setEnabled(false);
                } else {
                    this._upBtn.setEnabled(true);
                    this._topBtn.setEnabled(true);
                }
                if (this._selectedItems.get(this._selectedItems.size() - 1).equals(items.get(items.size() - 1))) {
                    this._downBtn.setEnabled(false);
                    this._bottomBtn.setEnabled(false);
                } else {
                    this._downBtn.setEnabled(true);
                    this._bottomBtn.setEnabled(true);
                }
            }
        }
    }
}

