/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import oracle.eclipse.tools.common.ui.dialogs.DetailsDialog;
import oracle.eclipse.tools.common.ui.dialogs.IToggleValue;
import oracle.eclipse.tools.common.ui.internal.CommonUiPlugin;
import oracle.eclipse.tools.common.ui.util.ThreadUtil;
import oracle.eclipse.tools.common.util.MutableReference;
import oracle.eclipse.tools.common.util.ResourceLoader;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DialogService {
    private static ResourceLoader _resourceLoader = new ResourceLoader(DialogService.class);

    private static Shell getActiveShell() {
        IWorkbenchWindow window;
        Shell active = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && !workbench.isClosing() && (window = workbench.getActiveWorkbenchWindow()) != null) {
            active = window.getShell();
        }
        return active;
    }

    private static void logActiveShellWarning(String title, String message) {
        String logEntry = _resourceLoader.resource("warning.noActiveShell", new Object[]{title, message});
        LoggingService.logWarning((Plugin)CommonUiPlugin.getDefault(), (String)logEntry);
    }

    public static boolean showConfirmDialog(final String title, final String message) {
        final MutableReference result = new MutableReference((Object)false);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Shell activeShell = DialogService.getActiveShell();
                if (activeShell != null) {
                    result.set((Object)MessageDialog.openConfirm((Shell)activeShell, (String)title, (String)message));
                } else {
                    result.set((Object)false);
                    DialogService.logActiveShellWarning(title, message);
                }
            }
        };
        ThreadUtil.ensureRunOnUIThread(runnable);
        return (Boolean)result.get();
    }

    public static void showErrorDialog(String message) {
        String errorTitle = _resourceLoader.resource("error.title", new Object[0]);
        DialogService.showErrorDialog(errorTitle, message);
    }

    public static void showErrorDialog(final String title, final String message) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Shell activeShell = DialogService.getActiveShell();
                if (activeShell != null) {
                    MessageDialog.openError((Shell)activeShell, (String)title, (String)message);
                } else {
                    DialogService.logActiveShellWarning(title, message);
                }
            }
        };
        ThreadUtil.ensureRunOnUIThread(runnable);
    }

    public static void showErrorDialog(final String message, final Throwable details) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Shell activeShell = DialogService.getActiveShell();
                if (!$assertionsDisabled && activeShell == null) {
                    throw new AssertionError((Object)"Active shell was null.");
                }
                String errorTitle = _resourceLoader.resource("error.title", new Object[0]);
                DetailsDialog.openError(activeShell, errorTitle, message, details, 0);
            }
        };
        ThreadUtil.ensureRunOnUIThread(runnable);
    }

    public static void showErrorDialog(Throwable exception) {
        Throwable realException = exception instanceof InvocationTargetException ? ((InvocationTargetException)exception).getTargetException() : exception;
        String message = realException.getMessage();
        if (message == null || message.trim().length() == 0) {
            message = realException.toString();
        }
        DialogService.showErrorDialog(message);
    }

    public static void showInfoDialog(final String title, final String message) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Shell activeShell = DialogService.getActiveShell();
                if (activeShell != null) {
                    MessageDialog.openInformation((Shell)activeShell, (String)title, (String)message);
                } else {
                    DialogService.logActiveShellWarning(title, message);
                }
            }
        };
        ThreadUtil.ensureRunOnUIThread(runnable);
    }

    public static void showWarningDialog(final String title, final String message) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Shell activeShell = DialogService.getActiveShell();
                if (activeShell != null) {
                    MessageDialog.openWarning((Shell)activeShell, (String)title, (String)message);
                } else {
                    DialogService.logActiveShellWarning(title, message);
                }
            }
        };
        ThreadUtil.ensureRunOnUIThread(runnable);
    }

    public static void showSuppressibleInfoDialog(final String title, final String message, final IPreferenceStore preferenceStore, final String preferenceKey, IToggleValue defaultValue) {
        assert (title != null);
        assert (message != null);
        assert (preferenceStore != null);
        assert (preferenceKey != null);
        assert (defaultValue != null);
        String value = preferenceStore.getString(preferenceKey);
        IToggleValue parsedValue = defaultValue.parse(value);
        if (defaultValue.equals(parsedValue)) {
            final String toggleMessage = _resourceLoader.resource("message.dontShow", new Object[0]);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Shell activeShell = DialogService.getActiveShell();
                    if (activeShell != null) {
                        MessageDialogWithToggle.openInformation((Shell)activeShell, (String)title, (String)message, (String)toggleMessage, (boolean)false, (IPreferenceStore)preferenceStore, (String)preferenceKey);
                    } else {
                        DialogService.logActiveShellWarning(title, message);
                    }
                }
            };
            ThreadUtil.ensureRunOnUIThread(runnable);
        }
    }

    public static void asyncShowSuppressibleInfoDialog(final String title, final String message, final IPreferenceStore preferenceStore, final String preferenceKey, IToggleValue defaultValue) {
        assert (title != null);
        assert (message != null);
        assert (preferenceStore != null);
        assert (preferenceKey != null);
        assert (defaultValue != null);
        String value = preferenceStore.getString(preferenceKey);
        IToggleValue parsedValue = defaultValue.parse(value);
        if (defaultValue.equals(parsedValue)) {
            final String toggleMessage = _resourceLoader.resource("message.dontShow", new Object[0]);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Shell activeShell = DialogService.getActiveShell();
                    if (activeShell != null) {
                        MessageDialogWithToggle.openInformation((Shell)activeShell, (String)title, (String)message, (String)toggleMessage, (boolean)false, (IPreferenceStore)preferenceStore, (String)preferenceKey);
                    } else {
                        DialogService.logActiveShellWarning(title, message);
                    }
                }
            };
            PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
        }
    }

    public static boolean showYesNoDialog(final String title, final String message) {
        final MutableReference result = new MutableReference((Object)false);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Shell activeShell = DialogService.getActiveShell();
                if (activeShell != null) {
                    result.set((Object)MessageDialog.openQuestion((Shell)activeShell, (String)title, (String)message));
                } else {
                    result.set((Object)false);
                    DialogService.logActiveShellWarning(title, message);
                }
            }
        };
        ThreadUtil.ensureRunOnUIThread(runnable);
        return (Boolean)result.get();
    }

    public static IToggleValue showSuppressibleYesNoDialog(String title, String message, IPreferenceStore preferenceStore, String preferenceKey, IToggleValue defaultValue) {
        return DialogService.showSuppressibleDialog(title, message, preferenceStore, preferenceKey, defaultValue, _resourceLoader.resource("message.remember", new Object[0]), true);
    }

    public static IToggleValue showSuppressibleDialog(final String title, final String message, final IPreferenceStore preferenceStore, final String preferenceKey, final IToggleValue defaultValue, final String toggleMessage, final boolean useYesNo) {
        assert (title != null);
        assert (message != null);
        assert (preferenceStore != null);
        assert (preferenceKey != null);
        assert (defaultValue != null);
        assert (toggleMessage != null);
        String value = preferenceStore.getString(preferenceKey);
        final MutableReference result = new MutableReference((Object)defaultValue.parse(value));
        if (defaultValue.equals(result.get())) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Shell activeShell = DialogService.getActiveShell();
                    if (activeShell != null) {
                        MessageDialogWithToggle dialog = useYesNo ? MessageDialogWithToggle.openYesNoQuestion((Shell)activeShell, (String)title, (String)message, (String)toggleMessage, (boolean)false, (IPreferenceStore)preferenceStore, (String)preferenceKey) : MessageDialogWithToggle.openOkCancelConfirm((Shell)activeShell, (String)title, (String)message, (String)toggleMessage, (boolean)false, (IPreferenceStore)preferenceStore, (String)preferenceKey);
                        result.set((Object)defaultValue.parseValueIndex(dialog.getReturnCode()));
                    } else {
                        DialogService.logActiveShellWarning(title, message);
                    }
                }
            };
            ThreadUtil.ensureRunOnUIThread(runnable);
        }
        return (IToggleValue)result.get();
    }
}

