/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.dialogs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DetailsDialog
extends MessageDialog {
    private final String detailMessage;
    private int detailButtonID = -1;
    private Text text;
    private int defaultButtonIndex = 0;
    private static final int TEXT_LINE_COUNT = 15;
    private static final String[] NO_DETAIL_LABELS = new String[]{IDialogConstants.OK_LABEL};
    private static final String[] DETAIL_LABELS = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.SHOW_DETAILS_LABEL};

    public DetailsDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, String detail, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.defaultButtonIndex = defaultIndex;
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10);
        this.detailMessage = detail;
    }

    public int open() {
        this.create();
        Button b = this.getButton(this.defaultButtonIndex);
        b.setFocus();
        b.getShell().setDefaultButton(b);
        return super.open();
    }

    public void setDetailButton(int index) {
        this.detailButtonID = index;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == this.detailButtonID) {
            this.toggleDetailsArea();
        } else {
            this.setReturnCode(buttonId);
            this.close();
        }
    }

    private void toggleDetailsArea() {
        this.text = DetailsDialog.toggleTextDetailArea(this.text, this.getButton(this.detailButtonID), this.detailMessage, (Composite)this.getContents(), this.getShell());
    }

    public static Text toggleTextDetailArea(Text text, Button button, Throwable t, Composite composite, Shell shell) {
        return DetailsDialog.toggleTextDetailArea(text, button, DetailsDialog.dumpStackTrace(t), composite, shell);
    }

    public static Text toggleTextDetailArea(Text text, Button button, String message, Composite composite, Shell shell) {
        Point windowSize = shell.getSize();
        Point oldSize = composite.computeSize(-1, -1);
        if (text != null) {
            text.dispose();
            text = null;
            button.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        } else {
            text = DetailsDialog.createMessageText(composite, message);
            button.setText(IDialogConstants.HIDE_DETAILS_LABEL);
        }
        Point newSize = composite.computeSize(-1, -1);
        shell.setSize(new Point(windowSize.x, windowSize.y + (newSize.y - oldSize.y)));
        return text;
    }

    private static Text createMessageText(Composite parent, String message) {
        Text textfield = new Text(parent, 2816);
        textfield.setFont(parent.getFont());
        textfield.setText(message);
        GridData data = new GridData(1808);
        data.heightHint = textfield.getLineHeight() * 15;
        data.horizontalSpan = 2;
        data.minimumHeight = data.heightHint + parent.getSize().y + 30;
        textfield.setLayoutData((Object)data);
        textfield.setEditable(false);
        return textfield;
    }

    public static void openError(Shell parent, String title, String message, Throwable detail, int defaultIndex) {
        if (detail == null) {
            throw new IllegalArgumentException("DetailsDialog.openError: detail Throwable can not be null.");
        }
        if (message == null || message.length() == 0) {
            Throwable cause = detail;
            while (message == null || message.length() == 0 && cause != null) {
                message = cause.getLocalizedMessage();
                Throwable throwable = cause = cause instanceof InvocationTargetException ? ((InvocationTargetException)cause).getTargetException() : cause.getCause();
            }
        }
        if (message == null || message.length() == 0) {
            message = detail.toString();
        }
        DetailsDialog.openError(parent, title, message, DetailsDialog.dumpStackTrace(detail), defaultIndex);
    }

    public static void openError(Shell parent, String title, String message, String detail, int defaultIndex) {
        DetailsDialog dialog = new DetailsDialog(parent, title, null, message, detail, 1, detail != null ? DETAIL_LABELS : NO_DETAIL_LABELS, defaultIndex);
        if (detail != null) {
            dialog.setDetailButton(1);
        }
        dialog.open();
    }

    private static String dumpStackTrace(Throwable t) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream((OutputStream)baos, false, "UTF-8");
            t.printStackTrace(ps);
            ps.flush();
            baos.flush();
            return baos.toString("UTF-8");
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

