/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.diagram.routers;

import java.util.ArrayList;
import oracle.eclipse.tools.common.ui.diagram.routers.DoublePoint;
import oracle.eclipse.tools.common.ui.diagram.routers.PathUtil;
import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Translatable;

public class SelfLoopConnectionRouter
extends AbstractRouter {
    private static double MIN_CONTROLPT_DIST = 24.0;
    private static double MAX_CONTROLPT_DIST = 36.0;

    public void route(Connection conn) {
        PointList points = conn.getPoints();
        points.removeAllPoints();
        Point ref1 = conn.getTargetAnchor().getReferencePoint();
        Point ref2 = conn.getSourceAnchor().getReferencePoint();
        PrecisionPoint startPoint = new PrecisionPoint(conn.getSourceAnchor().getLocation(ref1));
        conn.translateToRelative((Translatable)startPoint);
        PrecisionPoint endPoint = new PrecisionPoint(conn.getTargetAnchor().getLocation(ref2));
        conn.translateToRelative((Translatable)endPoint);
        DoublePoint p1 = new DoublePoint(startPoint.preciseX, startPoint.preciseY);
        DoublePoint p4 = new DoublePoint(endPoint.preciseX, endPoint.preciseY);
        double dist = PathUtil.dist(p1, p4) / 3.0;
        if (dist < MIN_CONTROLPT_DIST) {
            dist = MIN_CONTROLPT_DIST;
        }
        if (dist > MAX_CONTROLPT_DIST) {
            dist = MAX_CONTROLPT_DIST;
        }
        DoublePoint p2 = new DoublePoint(startPoint.preciseX + dist, (double)startPoint.y);
        DoublePoint p3 = new DoublePoint(endPoint.preciseX + dist, (double)endPoint.y);
        ArrayList<Double> doubles = new ArrayList<Double>();
        PathUtil.recursiveBezier(p1.x, p1.y, p2.x, p2.y, p3.x, p3.y, p4.x, p4.y, 4, doubles);
        points.addPoint((Point)startPoint);
        int i = 2;
        while (i < doubles.size() - 2) {
            PrecisionPoint p = new PrecisionPoint(((Double)doubles.get(i)).doubleValue(), ((Double)doubles.get(i + 1)).doubleValue());
            points.addPoint((Point)p);
            i += 2;
        }
        points.addPoint((Point)endPoint);
        conn.setPoints(points);
    }
}

