/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.diagram.parts;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.ui.diagram.editor.NodeDiagramEditor;
import oracle.eclipse.tools.common.ui.diagram.figures.RootNodeFigure;
import oracle.eclipse.tools.common.ui.diagram.model.RootNode;
import oracle.eclipse.tools.common.ui.diagram.parts.NodePart;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.Subgraph;

public class RootNodePart
extends NodePart {
    public RootNodePart(NodeDiagramEditor editor) {
        super(editor);
    }

    public RootNode getRootNode() {
        return (RootNode)this.getModel();
    }

    @Override
    protected IFigure createFigure() {
        RootNodeFigure nodeFigure = null;
        RootNode node = this.getRootNode();
        nodeFigure = new RootNodeFigure(node);
        return nodeFigure;
    }

    protected List getModelChildren() {
        return this.getRootNode().getAllChildren();
    }

    public IFigure getContentPane() {
        RootNodeFigure figure = (RootNodeFigure)this.getFigure();
        return figure.getColumnsFigure();
    }

    public List getChildrenSourceConnections() {
        ArrayList list = new ArrayList();
        for (Object child : this.getChildren()) {
            if (!(child instanceof NodePart)) continue;
            List srcConnections = ((NodePart)((Object)child)).getSourceConnections();
            list.addAll(srcConnections);
        }
        return list;
    }

    public List getChildrenTargetConnections() {
        ArrayList list = new ArrayList();
        for (Object child : this.getChildren()) {
            if (!(child instanceof NodePart)) continue;
            List targetConnections = ((NodePart)((Object)child)).getTargetConnections();
            list.addAll(targetConnections);
        }
        return list;
    }

    public Node newNodeForEditPart(Subgraph parent) {
        Node n = new Node((Object)this, parent);
        Dimension nodeD = this.getFigure().getPreferredSize(-1, -1);
        n.width = nodeD.width > 160 ? nodeD.width : 160;
        n.height = nodeD.height + 5;
        n.setPadding(new Insets(16, 24, 16, 24));
        int nConnections = this.getSourceConnections().size() + this.getChildrenSourceConnections().size();
        if (nConnections == 0) {
            n.setRowConstraint(100);
        } else {
            n.setRowConstraint(0);
        }
        return n;
    }

    public void updateConstraints() {
        IFigure figure = this.getFigure();
        if (figure instanceof RootNodeFigure) {
            ((RootNodeFigure)figure).updateConstraints();
        }
    }
}

