/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.diagram.parts;

import java.util.List;
import oracle.eclipse.tools.common.ui.diagram.editor.NodeDiagramEditor;
import oracle.eclipse.tools.common.ui.diagram.figures.INodeFigure;
import oracle.eclipse.tools.common.ui.diagram.figures.NodeRelationshipFigure;
import oracle.eclipse.tools.common.ui.diagram.model.Node;
import oracle.eclipse.tools.common.ui.diagram.parts.ChildNodePart;
import oracle.eclipse.tools.common.ui.diagram.parts.LeftAnchor;
import oracle.eclipse.tools.common.ui.diagram.parts.NodeRelationshipPart;
import oracle.eclipse.tools.common.ui.diagram.parts.RightAnchor;
import oracle.eclipse.tools.common.ui.diagram.policies.NodeSelectionEditPolicy;
import oracle.eclipse.tools.common.ui.diagram.routers.SelfLoopConnectionRouter;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public class NodePart
extends AbstractGraphicalEditPart
implements NodeEditPart {
    private NodeDiagramEditor _diagramEditor;

    public NodePart(NodeDiagramEditor editor) {
        this._diagramEditor = editor;
    }

    public Node getNode() {
        return (Node)this.getModel();
    }

    public NodeDiagramEditor getDiagramEditor() {
        return this._diagramEditor;
    }

    protected IFigure createFigure() {
        return null;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new NodeSelectionEditPolicy());
    }

    protected List getModelSourceConnections() {
        if (this.getNode().getReferences().size() > 0) {
            return this.getNode().getReferences();
        }
        return null;
    }

    protected List getModelTargetConnections() {
        if (this.getNode().getReferers().size() > 0) {
            return this.getNode().getReferers();
        }
        return null;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new RightAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new RightAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        boolean isSelfLink = NodePart.isSelfLink(connection);
        if (isSelfLink) {
            NodeRelationshipFigure conn = (NodeRelationshipFigure)connection.getFigure();
            conn.setConnectionRouter((ConnectionRouter)new SelfLoopConnectionRouter());
            return new RightAnchor(this.getFigure());
        }
        return new LeftAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new LeftAnchor(this.getFigure());
    }

    public INodeFigure getNodeFigure() {
        IFigure fig = this.getFigure();
        assert (fig instanceof INodeFigure);
        return (INodeFigure)fig;
    }

    public static boolean isSelfLink(ConnectionEditPart connection) {
        EditPart targetPart;
        boolean isSelfLink = false;
        assert (connection instanceof NodeRelationshipPart);
        NodeRelationshipPart relationshipPart = (NodeRelationshipPart)connection;
        EditPart sourcePart = relationshipPart.getSource();
        if (sourcePart instanceof ChildNodePart) {
            sourcePart = sourcePart.getParent();
        }
        if ((targetPart = relationshipPart.getTarget()) instanceof ChildNodePart) {
            targetPart = targetPart.getParent();
        }
        if (sourcePart == targetPart) {
            isSelfLink = true;
        }
        return isSelfLink;
    }
}

