/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.diagram.figures;

import java.util.List;
import oracle.eclipse.tools.common.ui.diagram.figures.ChildNodeFigure;
import oracle.eclipse.tools.common.ui.diagram.figures.ColumnsFigure;
import oracle.eclipse.tools.common.ui.diagram.figures.HeaderLabel;
import oracle.eclipse.tools.common.ui.diagram.figures.INodeFigure;
import oracle.eclipse.tools.common.ui.diagram.figures.NodeDiagramStyleSheets;
import oracle.eclipse.tools.common.ui.diagram.model.Node;
import oracle.eclipse.tools.common.ui.diagram.model.RootNode;
import oracle.eclipse.tools.common.ui.internal.CommonUiPlugin;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class RootNodeFigure
extends Figure
implements INodeFigure {
    public static Color tableColor = new Color(null, 255, 255, 206);
    public static final int MIN_NODE_WIDTH = 160;
    private Node _rootNode;
    private HeaderLabel _nameLabel;
    private ColumnsFigure _columnsFigure = new ColumnsFigure();
    private boolean _selected;
    private boolean _hasFocus;

    public RootNodeFigure(RootNode node) {
        this._rootNode = node;
        ToolbarLayout layout = new ToolbarLayout();
        layout.setVertical(true);
        layout.setStretchMinorAxis(true);
        this.setLayoutManager((LayoutManager)layout);
        this.setBackgroundColor(ColorConstants.white);
        this.setForegroundColor(ColorConstants.black);
        this.setOpaque(false);
        this._nameLabel = new HeaderLabel(this._rootNode.getDisplayLabel(), this._rootNode.getImage());
        if (node.getTooltip() != null) {
            Label tooltip = new Label(node.getTooltip());
            tooltip.setBorder(TOOL_TIP_BORDER);
            this._nameLabel.setToolTip((IFigure)tooltip);
        }
        this.add((IFigure)this._nameLabel);
        this.add((IFigure)this._columnsFigure);
    }

    protected void paintClientArea(Graphics graphics) {
        super.paintClientArea(graphics);
        graphics.pushState();
        Rectangle r = this.getBounds().getCopy();
        if (this._selected) {
            graphics.setForegroundColor(NodeDiagramStyleSheets.ROOT_NODE_OUTLINE_HILITE_COLOR);
            graphics.setLineWidth(2);
            graphics.drawRoundRectangle(r.expand(new Insets(-1, -1, -4, -2)), 6, 6);
        } else {
            Image bottomImage = CommonUiPlugin.Images.SHADOW_BOTTOM_IMAGE.getImage();
            Image sideImage = CommonUiPlugin.Images.SHADOW_SIDE_IMAGE.getImage();
            Image lowerRightImage = CommonUiPlugin.Images.SHADOW_LOWER_RIGHT_IMAGE.getImage();
            Image lowerLeftImage = CommonUiPlugin.Images.SHADOW_LOWER_LEFT_IMAGE.getImage();
            Image upperRightImage = CommonUiPlugin.Images.SHADOW_UPPER_RIGHT_IMAGE.getImage();
            int cr = 6;
            org.eclipse.swt.graphics.Rectangle imageRect = lowerLeftImage.getBounds();
            graphics.drawImage(lowerLeftImage, 0, 0, imageRect.width, imageRect.height, r.x, r.bottom() - imageRect.height, imageRect.width, imageRect.height);
            imageRect = bottomImage.getBounds();
            graphics.drawImage(bottomImage, 0, 0, imageRect.width, imageRect.height, r.x + cr, r.bottom() - imageRect.height, r.width - 2 * cr, imageRect.height);
            imageRect = upperRightImage.getBounds();
            graphics.drawImage(upperRightImage, 0, 0, imageRect.width, imageRect.height, r.right() - imageRect.width, r.y, imageRect.width, imageRect.height);
            imageRect = sideImage.getBounds();
            graphics.drawImage(sideImage, 0, 0, imageRect.width, imageRect.height, r.right() - imageRect.width, r.y + cr, imageRect.width, r.height - 2 * cr);
            imageRect = lowerRightImage.getBounds();
            graphics.drawImage(lowerRightImage, 0, 0, imageRect.width, imageRect.height, r.right() - imageRect.width, r.bottom() - imageRect.height, imageRect.width, imageRect.height);
            graphics.setForegroundColor(NodeDiagramStyleSheets.ROOT_NODE_OUTLINE_COLOR);
            Insets inset = new Insets(0, 0, -5, -5);
            graphics.drawRoundRectangle(r.getCopy().expand(inset), 6, 6);
        }
        graphics.popState();
    }

    public ColumnsFigure getColumnsFigure() {
        return this._columnsFigure;
    }

    public void updateConstraints() {
        List children = this._columnsFigure.getChildren();
        int width = this.getBounds().width;
        width = width > 160 ? width : 160;
        for (Object obj : children) {
            assert (obj instanceof ChildNodeFigure);
            ChildNodeFigure child = (ChildNodeFigure)obj;
            Dimension d2 = child.getPreferredSize().getCopy();
            d2.width = width;
            child.setPreferredSize(d2);
        }
    }

    @Override
    public void setSelected(boolean b) {
        this._selected = b;
        this.repaint();
    }

    @Override
    public boolean isSelected() {
        return this._selected;
    }

    @Override
    public void setFocus(boolean b) {
        this._hasFocus = b;
        this.repaint();
    }

    @Override
    public boolean hasFocus() {
        return this._hasFocus;
    }
}

