/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.diagram.figures;

import oracle.eclipse.tools.common.ui.diagram.figures.NodeDiagramStyleSheets;
import oracle.eclipse.tools.common.ui.diagram.figures.RootNodeFigure;
import oracle.eclipse.tools.common.ui.internal.CommonUiPlugin;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class HeaderLabel
extends Figure {
    private Label _headerLabel;

    public HeaderLabel(String text, Image image) {
        GridLayout gl = new GridLayout();
        gl.marginHeight = 3;
        gl.marginWidth = 12;
        this.setLayoutManager((LayoutManager)gl);
        this._headerLabel = new Label(text, image);
        this._headerLabel.setFont(NodeDiagramStyleSheets.getHeaderLabelFont());
        this._headerLabel.setTextPlacement(16);
        this._headerLabel.setLabelAlignment(1);
        this._headerLabel.setForegroundColor(NodeDiagramStyleSheets.HEADER_LABEL_COLOR);
        this.add((IFigure)this._headerLabel);
    }

    protected void paintFigure(Graphics graphics) {
        graphics.pushState();
        org.eclipse.draw2d.geometry.Rectangle rect = this.getBounds().getCopy();
        if (((RootNodeFigure)this.getParent()).isSelected()) {
            rect.expand(new Insets(-2, -2, 0, -1));
        } else {
            rect.expand(new Insets(-1, -1, 0, -3));
        }
        Image leftImage = CommonUiPlugin.Images.HEADER_BKGND_LEFT_IMAGE.getImage();
        Image rightImage = CommonUiPlugin.Images.HEADER_BKGND_RIGHT_IMAGE.getImage();
        Image centerImage = CommonUiPlugin.Images.HEADER_BKGND_CENTER_IMAGE.getImage();
        Rectangle imageRect = leftImage.getBounds();
        graphics.drawImage(leftImage, 0, 0, imageRect.width, imageRect.height, rect.x, rect.y, imageRect.width, rect.height);
        imageRect = rightImage.getBounds();
        graphics.drawImage(rightImage, 0, 0, imageRect.width, imageRect.height, rect.x + rect.width - imageRect.width, rect.y, imageRect.width - 2, rect.height);
        imageRect = centerImage.getBounds();
        int centerW = rect.width - leftImage.getBounds().width - rightImage.getBounds().width;
        graphics.drawImage(centerImage, 0, 0, imageRect.width, imageRect.height, rect.x + leftImage.getBounds().width, rect.y, centerW, rect.height);
        graphics.popState();
        super.paintFigure(graphics);
    }
}

