/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.diagram.figures;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.ui.diagram.figures.INodeFigure;
import oracle.eclipse.tools.common.ui.diagram.figures.NodeDiagramStyleSheets;
import oracle.eclipse.tools.common.ui.diagram.figures.NodeRelationshipFigure;
import oracle.eclipse.tools.common.ui.diagram.figures.RootNodeFigure;
import oracle.eclipse.tools.common.ui.diagram.model.ChildNode;
import oracle.eclipse.tools.common.ui.diagram.model.Node;
import oracle.eclipse.tools.common.ui.diagram.model.RootNode;
import oracle.eclipse.tools.common.ui.diagram.parts.NodePart;
import oracle.eclipse.tools.common.ui.diagram.parts.NodeRelationshipPart;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;

public class ChildNodeFigure
extends Figure
implements INodeFigure {
    private NodePart nodePart;
    private Node node;
    private RootNode parentNode;
    private Label _nodeLabel;
    private boolean _selected;
    private boolean _hasFocus;
    private boolean _mouseOver;

    public ChildNodeFigure(NodePart nodePart, String text, Image image) {
        this.nodePart = nodePart;
        this.node = (Node)nodePart.getModel();
        assert (this.node instanceof ChildNode);
        this.parentNode = (RootNode)((ChildNode)this.node).getParent();
        GridLayout gl = new GridLayout();
        gl.marginHeight = 4;
        gl.marginWidth = 12;
        this.setLayoutManager((LayoutManager)gl);
        this._nodeLabel = new Label(text, image);
        if (image == null) {
            this._nodeLabel.setIconDimension(new Dimension(16, 16));
        }
        this._nodeLabel.setTextPlacement(16);
        this._nodeLabel.setFont(NodeDiagramStyleSheets.getChildLabelFont());
        this._nodeLabel.setLabelAlignment(128);
        this._nodeLabel.setForegroundColor(NodeDiagramStyleSheets.CHILD_LABEL_COLOR);
        if (this.node.getTooltip() != null) {
            Label tooltip = new Label(this.node.getTooltip());
            tooltip.setBorder(TOOL_TIP_BORDER);
            this._nodeLabel.setToolTip((IFigure)tooltip);
        }
        this.add((IFigure)this._nodeLabel);
        this.addListeners();
    }

    protected void paintFigure(Graphics graphics) {
        graphics.pushState();
        Rectangle r = this.getBounds().getCopy();
        if (this._mouseOver) {
            graphics.setBackgroundColor(NodeDiagramStyleSheets.LINK_MOUSE_OVER_COLOR);
            graphics.fillRectangle(r.getCopy().expand(-1, 0));
        } else if (this._selected) {
            graphics.setBackgroundColor(NodeDiagramStyleSheets.CHILD_NODE_FILL_HILITE_COLOR);
            graphics.fillRectangle(r.getCopy().expand(-1, 0));
            graphics.setForegroundColor(NodeDiagramStyleSheets.CHILD_NODE_OUTLINE_HILITE_COLOR);
            graphics.setLineWidth(2);
            Insets insets = new Insets(-1, -1, -1, -6);
            graphics.drawRectangle(r.expand(insets));
        } else {
            Insets insets = null;
            RootNodeFigure parentNodeFigure = (RootNodeFigure)this.getParent().getParent();
            insets = parentNodeFigure.isSelected() ? new Insets(-1, -1, 0, -3) : new Insets(-1, -1, 0, -5);
            this.node.paintBackground(graphics, r.getCopy().expand(insets));
            graphics.setForegroundColor(NodeDiagramStyleSheets.CHILD_NODE_OUTLINE_COLOR);
            if (!this.parentNode.isFirstChild(this.node)) {
                graphics.setLineDash(new int[]{2, 2});
            }
            graphics.drawLine(r.x + 1, r.y, r.x + r.width - 5, r.y);
        }
        graphics.popState();
        super.paintFigure(graphics);
    }

    @Override
    public void setSelected(boolean b) {
        this._selected = b;
        List<NodeRelationshipFigure> allLinks = this.getAllLinks();
        for (NodeRelationshipFigure relationFigure : allLinks) {
            relationFigure.setSelected(b);
        }
    }

    @Override
    public boolean isSelected() {
        return this._selected;
    }

    @Override
    public void setFocus(boolean b) {
        this._hasFocus = b;
        this.repaint();
    }

    @Override
    public boolean hasFocus() {
        return this._hasFocus;
    }

    public void setMouseOver(boolean mouseOver) {
        this._mouseOver = mouseOver;
        if (!this._mouseOver) {
            this._nodeLabel.setForegroundColor(NodeDiagramStyleSheets.CHILD_LABEL_COLOR);
        } else {
            this._nodeLabel.setForegroundColor(ColorConstants.white);
        }
    }

    public boolean isMouseOver() {
        return this._mouseOver;
    }

    private void addListeners() {
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent me) {
            }

            public void mouseEntered(MouseEvent me) {
                ChildNodeFigure.this.setMouseOver(true);
                List allLinks = ChildNodeFigure.this.getAllLinks();
                for (NodeRelationshipFigure relationFigure : allLinks) {
                    relationFigure.setMouseOver(true);
                }
                ChildNodeFigure.this.repaint();
            }

            public void mouseExited(MouseEvent me) {
                ChildNodeFigure.this.setMouseOver(false);
                List allLinks = ChildNodeFigure.this.getAllLinks();
                for (NodeRelationshipFigure relationFigure : allLinks) {
                    relationFigure.setMouseOver(false);
                }
                ChildNodeFigure.this.repaint();
            }

            public void mouseHover(MouseEvent me) {
            }

            public void mouseMoved(MouseEvent me) {
            }
        });
    }

    private List<NodeRelationshipFigure> getAllLinks() {
        ArrayList<NodeRelationshipFigure> allLinks = new ArrayList<NodeRelationshipFigure>();
        List srcConns = this.nodePart.getSourceConnections();
        for (Object srcConnObj : srcConns) {
            assert (srcConnObj instanceof NodeRelationshipPart);
            NodeRelationshipPart relationPart = (NodeRelationshipPart)((Object)srcConnObj);
            assert (relationPart.getFigure() instanceof NodeRelationshipFigure);
            NodeRelationshipFigure relationFigure = (NodeRelationshipFigure)relationPart.getFigure();
            allLinks.add(relationFigure);
        }
        List targetConns = this.nodePart.getTargetConnections();
        for (Object targetConnObj : targetConns) {
            assert (targetConnObj instanceof NodeRelationshipPart);
            NodeRelationshipPart relationPart = (NodeRelationshipPart)((Object)targetConnObj);
            assert (relationPart.getFigure() instanceof NodeRelationshipFigure);
            NodeRelationshipFigure relationFigure = (NodeRelationshipFigure)relationPart.getFigure();
            allLinks.add(relationFigure);
        }
        return allLinks;
    }
}

