/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.diagram.editor;

import oracle.eclipse.tools.common.ui.diagram.actions.DiagramActionMessages;
import oracle.eclipse.tools.common.ui.diagram.actions.GraphEditorExportToImageAction;
import oracle.eclipse.tools.common.ui.diagram.actions.GraphicalEditorPrintAction;
import oracle.eclipse.tools.common.ui.diagram.actions.RefreshAction;
import oracle.eclipse.tools.common.ui.diagram.actions.SwitchLinkStyleAction;
import oracle.eclipse.tools.common.ui.diagram.actions.ZoomAction;
import oracle.eclipse.tools.common.ui.diagram.editor.NodeDiagramEditor;
import oracle.eclipse.tools.common.ui.diagram.figures.NodeDiagramStyleSheets;
import oracle.eclipse.tools.common.ui.diagram.layout.DiagramLinkStyle;
import oracle.eclipse.tools.common.ui.diagram.model.NodeDiagramModel;
import oracle.eclipse.tools.common.ui.diagram.parts.NodeDiagramPart;
import oracle.eclipse.tools.common.ui.internal.CommonUiPlugin;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;

public abstract class NodeDiagramToolbarPane {
    protected NodeDiagramEditor editor;
    protected GraphicalViewer viewer;
    protected Canvas toolbarCanvas;
    protected Image toolbarBgImage = CommonUiPlugin.Images.TOOLBAR_BG_IMAGE.getImage();
    protected FigureCanvas linkStyleToolBarCanvas;
    protected Figure linkStyleToolBarBGFigure;
    protected FigureCanvas rightToolBarCanvas;
    protected Figure rightToolBarBGFigure;
    protected Canvas comboParent;
    protected CCombo zoomCombo;
    protected Label splineLinkBtn;
    protected Label straightLinkBtn;
    protected Label orthogonalLinkBtn;
    protected Label exportBtn;
    protected Label printBtn;
    protected Label refreshBtn;
    protected Image splineLinkImage = CommonUiPlugin.Images.LINK_CURVED_IMAGE.getImage();
    protected Image splineLinkHoverImage = CommonUiPlugin.Images.LINK_CURVED_HOVER_IMAGE.getImage();
    protected Image splineLinkOnImage = CommonUiPlugin.Images.LINK_CURVED_ON_IMAGE.getImage();
    protected Image straightLinkImage = CommonUiPlugin.Images.LINK_STRAIGHT_IMAGE.getImage();
    protected Image straightLinkHoverImage = CommonUiPlugin.Images.LINK_STRAIGHT_HOVER_IMAGE.getImage();
    protected Image straightLinkOnImage = CommonUiPlugin.Images.LINK_STRAIGHT_ON_IMAGE.getImage();
    protected Image orthogonalLinkImage = CommonUiPlugin.Images.LINK_ORTHOGONAL_IMAGE.getImage();
    protected Image orthogonalLinkHoverImage = CommonUiPlugin.Images.LINK_ORTHOGONAL_HOVER_IMAGE.getImage();
    protected Image orthogonalLinkOnImage = CommonUiPlugin.Images.LINK_ORTHOGONAL_ON_IMAGE.getImage();
    protected Image exportImage = CommonUiPlugin.Images.EXPORT_IMAGE.getImage();
    protected Image exportHoverImage = CommonUiPlugin.Images.EXPORT_HOVER_IMAGE.getImage();
    protected Image printImage = CommonUiPlugin.Images.PRINT_IMAGE.getImage();
    protected Image printHoverImage = CommonUiPlugin.Images.PRINT_HOVER_IMAGE.getImage();
    protected Image refreshImage = CommonUiPlugin.Images.REFRESH_IMAGE.getImage();
    protected Image refreshHoverImage = CommonUiPlugin.Images.REFRESH_HOVER_IMAGE.getImage();
    public static final int PANE_PADDING = 9;
    public static final int DEFAULT_PANE_HEIGHT = 27;
    protected int paneHeight = -1;
    protected static final int ZOOM_COMBO_WIDTH = 95;
    protected static final int ZOOM_COMBO_HEIGHT = 16;
    protected static final int LINK_STYLE_TOOLBAR_WIDTH = 98;
    protected static final int RIGHT_TOOLBAR_WIDTH = 95;
    protected static final int IMAGE_WIDTH = 24;
    protected static final int IMAGE_HEIGHT = 22;

    protected void setSizeVariables() {
        FontMetrics fm = FigureUtilities.getFontMetrics((Font)this.toolbarCanvas.getFont());
        this.paneHeight = Math.max(27, fm.getHeight() + 9);
    }

    protected void createLinkStyleToolBar() {
        this.linkStyleToolBarCanvas = new FigureCanvas((Composite)this.toolbarCanvas);
        this.linkStyleToolBarCanvas.setHorizontalScrollBarVisibility(FigureCanvas.NEVER);
        this.linkStyleToolBarCanvas.setVerticalScrollBarVisibility(FigureCanvas.NEVER);
        this.linkStyleToolBarBGFigure = new ToolBarFigureWithSeparator(false);
        this.linkStyleToolBarBGFigure.setLayoutManager((LayoutManager)new XYLayout());
        this.linkStyleToolBarBGFigure.setMinimumSize(new Dimension(98, this.paneHeight));
        this.linkStyleToolBarBGFigure.setPreferredSize(new Dimension(98, this.paneHeight));
        this.linkStyleToolBarCanvas.setContents((IFigure)this.linkStyleToolBarBGFigure);
        this.createLinkStyleToolBarButtons();
        this.layoutLinkStyleToolBarButtons();
    }

    protected void createLinkStyleToolBarButtons() {
        this.createSplineLinkToolItem();
        this.createStraightLinkToolItem();
        this.createOrthogonalLinkToolItem();
    }

    protected void layoutLinkStyleToolBarButtons() {
        int xinset = 5;
        int y = (this.paneHeight - 22) / 2;
        int nextX = xinset;
        Rectangle r = new Rectangle(nextX, y, 24, 22);
        this.linkStyleToolBarBGFigure.add((IFigure)this.splineLinkBtn, (Object)r);
        r = new Rectangle(nextX += 24 + xinset, y, 24, 22);
        this.linkStyleToolBarBGFigure.add((IFigure)this.straightLinkBtn, (Object)r);
        r = new Rectangle(nextX += 24 + xinset, y, 24, 22);
        this.linkStyleToolBarBGFigure.add((IFigure)this.orthogonalLinkBtn, (Object)r);
    }

    protected void createRightToolBar() {
        this.rightToolBarCanvas = new FigureCanvas((Composite)this.toolbarCanvas);
        this.rightToolBarCanvas.setHorizontalScrollBarVisibility(FigureCanvas.NEVER);
        this.rightToolBarCanvas.setVerticalScrollBarVisibility(FigureCanvas.NEVER);
        this.rightToolBarBGFigure = new ToolBarFigureWithSeparator();
        this.rightToolBarBGFigure.setLayoutManager((LayoutManager)new XYLayout());
        this.rightToolBarBGFigure.setMinimumSize(new Dimension(95, this.paneHeight));
        this.rightToolBarBGFigure.setPreferredSize(new Dimension(95, this.paneHeight));
        this.rightToolBarCanvas.setContents((IFigure)this.rightToolBarBGFigure);
        this.createRightToolBarButtons();
        this.layoutRightToolBarButtons();
    }

    protected void createRightToolBarButtons() {
        this.createExportToImageToolItem();
        this.createPrintGraphToolItem();
        this.createRefreshToolItem();
    }

    protected void layoutRightToolBarButtons() {
        int xinset = 5;
        int y = (this.paneHeight - 22) / 2;
        int nextX = xinset + 5;
        Rectangle r = new Rectangle(nextX, y, 24, 22);
        this.rightToolBarBGFigure.add((IFigure)this.exportBtn, (Object)r);
        r = new Rectangle(nextX += 24 + xinset, y, 24, 22);
        this.rightToolBarBGFigure.add((IFigure)this.printBtn, (Object)r);
        r = new Rectangle(nextX += 24 + xinset, y, 24, 22);
        this.rightToolBarBGFigure.add((IFigure)this.refreshBtn, (Object)r);
    }

    protected Figure createSplineLinkToolItem() {
        this.splineLinkBtn = new Label(this.splineLinkOnImage);
        this.splineLinkBtn.setToolTip((IFigure)new Label(DiagramActionMessages.splineLinkText));
        this.splineLinkBtn.setOpaque(false);
        this.splineLinkBtn.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mousePressed(MouseEvent me) {
                if (NodeDiagramToolbarPane.this.getGraphicalEditor().getModelEditPart() == null) {
                    return;
                }
                SwitchLinkStyleAction action = new SwitchLinkStyleAction(NodeDiagramToolbarPane.this.editor, DiagramLinkStyle.SplineLinkStyle);
                action.run();
                NodeDiagramToolbarPane.this.viewer.getControl().forceFocus();
            }
        });
        HoverCondition splineHoverCondition = new HoverCondition(this){

            @Override
            public boolean enableHover() {
                return editor.getLinkStyle() != DiagramLinkStyle.SplineLinkStyle;
            }
        };
        this.splineLinkBtn.addMouseMotionListener((MouseMotionListener)new ToolBarMouseMotionListener(this.splineLinkBtn, this.splineLinkImage, this.splineLinkHoverImage, splineHoverCondition));
        return this.splineLinkBtn;
    }

    protected Figure createStraightLinkToolItem() {
        this.straightLinkBtn = new Label(this.straightLinkImage);
        this.straightLinkBtn.setToolTip((IFigure)new Label(DiagramActionMessages.straightLinkText));
        this.straightLinkBtn.setOpaque(false);
        this.straightLinkBtn.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mousePressed(MouseEvent me) {
                if (NodeDiagramToolbarPane.this.getGraphicalEditor().getModelEditPart() == null) {
                    return;
                }
                SwitchLinkStyleAction action = new SwitchLinkStyleAction(NodeDiagramToolbarPane.this.editor, DiagramLinkStyle.StraightLinkStyle);
                action.run();
                NodeDiagramToolbarPane.this.viewer.getControl().forceFocus();
            }
        });
        HoverCondition straightHoverCondition = new HoverCondition(this){

            @Override
            public boolean enableHover() {
                return editor.getLinkStyle() != DiagramLinkStyle.StraightLinkStyle;
            }
        };
        this.straightLinkBtn.addMouseMotionListener((MouseMotionListener)new ToolBarMouseMotionListener(this.straightLinkBtn, this.straightLinkImage, this.straightLinkHoverImage, straightHoverCondition));
        return this.straightLinkBtn;
    }

    protected Figure createOrthogonalLinkToolItem() {
        this.orthogonalLinkBtn = new Label(this.orthogonalLinkImage);
        this.orthogonalLinkBtn.setToolTip((IFigure)new Label(DiagramActionMessages.orthogonalLinkText));
        this.orthogonalLinkBtn.setOpaque(false);
        this.orthogonalLinkBtn.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mousePressed(MouseEvent me) {
                if (NodeDiagramToolbarPane.this.getGraphicalEditor().getModelEditPart() == null) {
                    return;
                }
                SwitchLinkStyleAction action = new SwitchLinkStyleAction(NodeDiagramToolbarPane.this.editor, DiagramLinkStyle.OrthogonalLinkStyle);
                action.run();
                NodeDiagramToolbarPane.this.viewer.getControl().forceFocus();
            }
        });
        HoverCondition orthogonalHoverCondition = new HoverCondition(this){

            @Override
            public boolean enableHover() {
                return editor.getLinkStyle() != DiagramLinkStyle.OrthogonalLinkStyle;
            }
        };
        this.orthogonalLinkBtn.addMouseMotionListener((MouseMotionListener)new ToolBarMouseMotionListener(this.orthogonalLinkBtn, this.orthogonalLinkImage, this.orthogonalLinkHoverImage, orthogonalHoverCondition));
        return this.orthogonalLinkBtn;
    }

    protected Figure createExportToImageToolItem() {
        this.exportBtn = new Label(this.exportImage);
        this.exportBtn.setToolTip((IFigure)new Label(DiagramActionMessages.exportText));
        this.exportBtn.setOpaque(false);
        this.exportBtn.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mousePressed(MouseEvent me) {
                NodeDiagramPart modelPart = NodeDiagramToolbarPane.this.getGraphicalEditor().getModelEditPart();
                if (modelPart == null) {
                    return;
                }
                NodeDiagramModel model = (NodeDiagramModel)modelPart.getModel();
                String defaultImageName = NodeDiagramToolbarPane.this.getGraphicalEditor().getDefaultImageName(model.getModelName());
                GraphEditorExportToImageAction egvAction = new GraphEditorExportToImageAction(NodeDiagramToolbarPane.this.viewer, modelPart.getFigure(), null, defaultImageName);
                egvAction.run();
                NodeDiagramToolbarPane.this.viewer.getControl().forceFocus();
            }
        });
        this.exportBtn.addMouseMotionListener((MouseMotionListener)new ToolBarMouseMotionListener(this.exportBtn, this.exportImage, this.exportHoverImage, new HoverCondition()));
        return this.exportBtn;
    }

    protected Figure createPrintGraphToolItem() {
        this.printBtn = new Label(this.printImage);
        this.printBtn.setToolTip((IFigure)new Label(DiagramActionMessages.printText));
        this.printBtn.setOpaque(false);
        this.printBtn.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mousePressed(MouseEvent me) {
                if (NodeDiagramToolbarPane.this.getGraphicalEditor().getModelEditPart() == null) {
                    return;
                }
                GraphicalEditorPrintAction printAction = new GraphicalEditorPrintAction((IWorkbenchPart)NodeDiagramToolbarPane.this.editor);
                printAction.run();
                NodeDiagramToolbarPane.this.viewer.getControl().forceFocus();
            }
        });
        this.printBtn.addMouseMotionListener((MouseMotionListener)new ToolBarMouseMotionListener(this.printBtn, this.printImage, this.printHoverImage, new HoverCondition()));
        return this.printBtn;
    }

    protected Figure createRefreshToolItem() {
        this.refreshBtn = new Label(this.refreshImage);
        this.refreshBtn.setToolTip((IFigure)new Label(DiagramActionMessages.refreshText));
        this.refreshBtn.setOpaque(false);
        this.refreshBtn.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mousePressed(MouseEvent me) {
                if (NodeDiagramToolbarPane.this.getGraphicalEditor().getModelEditPart() == null) {
                    return;
                }
                RefreshAction refreshAction = new RefreshAction(NodeDiagramToolbarPane.this.editor);
                refreshAction.run();
                NodeDiagramToolbarPane.this.viewer.getControl().forceFocus();
            }
        });
        this.refreshBtn.addMouseMotionListener((MouseMotionListener)new ToolBarMouseMotionListener(this.refreshBtn, this.refreshImage, this.refreshHoverImage, new HoverCondition()));
        return this.refreshBtn;
    }

    public void setGraphicalEditor(NodeDiagramEditor editor) {
        this.editor = editor;
        this.viewer = editor.getViewer();
        ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)this.viewer.getRootEditPart();
        final ZoomManager zoomManager = rootEditPart.getZoomManager();
        zoomManager.addZoomListener(new ZoomListener(){

            public void zoomChanged(double zoom) {
                String zoomLevel = zoomManager.getZoomAsText();
                NodeDiagramToolbarPane.this.setCurrentZoomLevel(zoomLevel);
            }
        });
    }

    public NodeDiagramEditor getGraphicalEditor() {
        return this.editor;
    }

    public GraphicalViewer getGraphicalViewer() {
        return this.viewer;
    }

    public void setCurrentZoomLevel(String zoom) {
        this.zoomCombo.setText(zoom);
    }

    public String getCurrentZoomLevel() {
        return this.zoomCombo.getText();
    }

    protected Canvas createZoomCombo(Composite parent) {
        this.comboParent = new Canvas(parent, 0);
        this.zoomCombo = new CCombo((Composite)this.comboParent, 0x800804);
        this.zoomCombo.setToolTipText(DiagramActionMessages.zoomText);
        this.zoomCombo.add("200%");
        this.zoomCombo.add("150%");
        this.zoomCombo.add("100%");
        this.zoomCombo.add("75%");
        this.zoomCombo.add("50%");
        this.zoomCombo.add(ZoomAction.FIT_TO_WINDOW);
        this.zoomCombo.setVisibleItemCount(6);
        this.zoomCombo.select(2);
        Font oldFont = this.zoomCombo.getFont();
        FontData[] fdarray = oldFont.getFontData();
        assert (fdarray.length > 0) : "empty font data";
        FontData fd = fdarray[0];
        this.zoomCombo.setFont(new Font((Device)this.zoomCombo.getDisplay(), fd.getName(), fd.getHeight() - 1, fd.getStyle()));
        this.zoomCombo.setBounds(0, 0, 95, 16);
        this.zoomCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = NodeDiagramToolbarPane.this.zoomCombo.getSelectionIndex();
                String zoomStr = index > -1 ? NodeDiagramToolbarPane.this.zoomCombo.getItem(index) : NodeDiagramToolbarPane.this.zoomCombo.getText();
                NodeDiagramToolbarPane.this.runZoomAction(zoomStr);
                NodeDiagramToolbarPane.this.viewer.getControl().forceFocus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.zoomCombo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                String zoomStr = NodeDiagramToolbarPane.this.zoomCombo.getText();
                NodeDiagramToolbarPane.this.runZoomAction(zoomStr);
                NodeDiagramToolbarPane.this.viewer.getControl().forceFocus();
            }
        });
        this.zoomCombo.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.keyCode == 13) {
                    String zoomStr = NodeDiagramToolbarPane.this.zoomCombo.getText();
                    NodeDiagramToolbarPane.this.runZoomAction(zoomStr);
                    NodeDiagramToolbarPane.this.viewer.getControl().forceFocus();
                }
            }
        });
        this.zoomCombo.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13) {
                    String zoomStr = NodeDiagramToolbarPane.this.zoomCombo.getText();
                    NodeDiagramToolbarPane.this.runZoomAction(zoomStr);
                    NodeDiagramToolbarPane.this.viewer.getControl().forceFocus();
                }
            }
        });
        return this.comboParent;
    }

    protected void runZoomAction(String zoomStr) {
        if (zoomStr != null) {
            zoomStr = zoomStr.trim();
        }
        ZoomAction zoomAction = new ZoomAction(this.viewer, this, zoomStr);
        zoomAction.run();
        String zoomLevel = null;
        if (zoomStr.equals(ZoomAction.FIT_TO_WINDOW)) {
            zoomLevel = zoomStr;
        } else {
            ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)this.viewer.getRootEditPart();
            ZoomManager zoomManager = rootEditPart.getZoomManager();
            zoomLevel = zoomManager.getZoomAsText();
        }
        this.setCurrentZoomLevel(zoomLevel);
    }

    public void updateToolbar() {
        if (this.splineLinkBtn != null) {
            if (this.editor.getLinkStyle() == DiagramLinkStyle.SplineLinkStyle) {
                this.splineLinkBtn.setIcon(this.splineLinkOnImage);
            } else {
                this.splineLinkBtn.setIcon(this.splineLinkImage);
            }
        }
        if (this.straightLinkBtn != null) {
            if (this.editor.getLinkStyle() == DiagramLinkStyle.StraightLinkStyle) {
                this.straightLinkBtn.setIcon(this.straightLinkOnImage);
            } else {
                this.straightLinkBtn.setIcon(this.straightLinkImage);
            }
        }
        if (this.orthogonalLinkBtn != null) {
            if (this.editor.getLinkStyle() == DiagramLinkStyle.OrthogonalLinkStyle) {
                this.orthogonalLinkBtn.setIcon(this.orthogonalLinkOnImage);
            } else {
                this.orthogonalLinkBtn.setIcon(this.orthogonalLinkImage);
            }
        }
    }

    protected class HoverCondition {
        public boolean enableHover() {
            return true;
        }
    }

    public class ToolBarFigure
    extends Figure {
        protected Rectangle bounds;

        public void paint(Graphics g) {
            Color localFg;
            this.bounds = this.getBounds();
            Color localBg = this.getLocalBackgroundColor();
            if (localBg != null) {
                g.setBackgroundColor(localBg);
            }
            if ((localFg = this.getLocalForegroundColor()) != null) {
                g.setForegroundColor(localFg);
            }
            g.pushState();
            try {
                this.paintFigure(g);
                this.paintBackground(g);
                g.restoreState();
                this.paintClientArea(g);
            }
            finally {
                g.popState();
            }
        }

        protected void paintBackground(Graphics g) {
            org.eclipse.swt.graphics.Rectangle imageRect = NodeDiagramToolbarPane.this.toolbarBgImage.getBounds();
            g.drawImage(NodeDiagramToolbarPane.this.toolbarBgImage, 0, 0, imageRect.width, imageRect.height, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        }
    }

    public class ToolBarFigureWithSeparator
    extends ToolBarFigure {
        private boolean leftSeparator;

        public ToolBarFigureWithSeparator() {
            this(true);
        }

        public ToolBarFigureWithSeparator(boolean leftSeparator) {
            this.leftSeparator = leftSeparator;
        }

        @Override
        protected void paintBackground(Graphics g) {
            super.paintBackground(g);
            g.setForegroundColor(NodeDiagramStyleSheets.TOOLBAR_SEPARATOR_COLOR);
            if (this.leftSeparator) {
                g.drawLine(this.bounds.x + 5, this.bounds.y + 5, this.bounds.x + 5, this.bounds.y + this.bounds.height - 5);
            } else {
                g.drawLine(this.bounds.x + this.bounds.width - 6, this.bounds.y + 5, this.bounds.x + this.bounds.width - 6, this.bounds.y + this.bounds.height - 5);
            }
        }
    }

    protected class ToolBarMouseMotionListener
    implements MouseMotionListener {
        private Label _button;
        private Image _image;
        private Image _hoverImage;
        HoverCondition _hoverCondition;

        public ToolBarMouseMotionListener(Label button, Image image, Image hoverImage, HoverCondition hoverCondition) {
            this._button = button;
            this._image = image;
            this._hoverImage = hoverImage;
            this._hoverCondition = hoverCondition;
        }

        public void mouseDragged(MouseEvent me) {
        }

        public void mouseEntered(MouseEvent me) {
            if (this._hoverCondition.enableHover()) {
                this._button.setIcon(this._hoverImage);
            }
        }

        public void mouseExited(MouseEvent me) {
            if (this._hoverCondition.enableHover()) {
                this._button.setIcon(this._image);
            }
        }

        public void mouseHover(MouseEvent me) {
        }

        public void mouseMoved(MouseEvent me) {
        }
    }
}

