/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.diagram.editor;

import java.util.List;
import oracle.eclipse.tools.common.ui.diagram.actions.DiagramActionMessages;
import oracle.eclipse.tools.common.ui.diagram.actions.GraphicalEditorPrintAction;
import oracle.eclipse.tools.common.ui.diagram.actions.ZoomAction;
import oracle.eclipse.tools.common.ui.diagram.editor.DiagramOutlinePage;
import oracle.eclipse.tools.common.ui.diagram.editor.NodeDiagramContextMenuProvider;
import oracle.eclipse.tools.common.ui.diagram.editor.NodeDiagramEditorInput;
import oracle.eclipse.tools.common.ui.diagram.editor.NodeDiagramToolbarPane;
import oracle.eclipse.tools.common.ui.diagram.layout.DiagramLinkStyle;
import oracle.eclipse.tools.common.ui.diagram.model.Node;
import oracle.eclipse.tools.common.ui.diagram.model.NodeDiagramModel;
import oracle.eclipse.tools.common.ui.diagram.parts.NodeDiagramPart;
import oracle.eclipse.tools.common.ui.diagram.parts.NodePart;
import oracle.eclipse.tools.common.ui.diagram.parts.NodePartFactory;
import oracle.eclipse.tools.common.ui.diagram.parts.NodeRelationshipPart;
import oracle.eclipse.tools.common.ui.diagram.parts.RootNodePart;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.tools.PanningSelectionTool;
import org.eclipse.gef.ui.actions.PrintAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class NodeDiagramEditor
extends GraphicalEditor {
    private ScrollingGraphicalViewer viewer;
    private NodeDiagramModel model;
    private NodeDiagramToolbarPane toolbarPane;
    private DiagramOutlinePage outlinePage;
    private GraphicalEditorPrintAction printAction;
    private DiagramLinkStyle linkStyle;

    public NodeDiagramEditor() {
        DefaultEditDomain ded = new DefaultEditDomain(null);
        PanningSelectionTool pst = new PanningSelectionTool();
        ded.setDefaultTool((Tool)pst);
        ded.setActiveTool((Tool)pst);
        this.setEditDomain(ded);
        this.printAction = new GraphicalEditorPrintAction((IWorkbenchPart)this);
        this.linkStyle = DiagramLinkStyle.SplineLinkStyle;
    }

    protected void initializeGraphicalViewer() {
        this.getGraphicalViewer().setContents((Object)this.model);
        this.enableZoomKeyBindings();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void setFocus() {
        super.setFocus();
        IActionBars bars = this.getEditorSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.PRINT.getId(), (IAction)this.getPrintAction());
        bars.updateActionBars();
    }

    public PrintAction getPrintAction() {
        return this.printAction;
    }

    public NodeDiagramToolbarPane createToolbarPane(Composite parent) {
        return null;
    }

    public NodeDiagramToolbarPane getToolbarPane() {
        return this.toolbarPane;
    }

    public NodePartFactory getNodePartFactory() {
        return new NodePartFactory(this);
    }

    public MenuManager getContextMenuManager() {
        return new NodeDiagramContextMenuProvider(this);
    }

    public NodeDiagramPart getModelEditPart() {
        EditPart ep = this.getViewer().getRootEditPart().getContents();
        if (ep == null) {
            return null;
        }
        assert (ep instanceof NodeDiagramPart);
        return (NodeDiagramPart)ep;
    }

    public String getDefaultImageName(String modelName) {
        int lastSeparator;
        int lastDot = modelName.lastIndexOf(46);
        if (lastDot != -1) {
            modelName = modelName.substring(0, lastDot);
        }
        if ((lastSeparator = modelName.lastIndexOf(47)) != -1) {
            modelName = modelName.substring(lastSeparator + 1, modelName.length());
        }
        return modelName;
    }

    protected void createGraphicalViewer(Composite parent) {
        Canvas main = new Canvas(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.marginBottom = 0;
        gl.marginLeft = 0;
        gl.marginRight = 0;
        gl.marginTop = 0;
        main.setLayout((Layout)gl);
        main.setBackground(ColorConstants.white);
        this.toolbarPane = this.createToolbarPane((Composite)main);
        this.viewer = new ScrollingGraphicalViewer();
        ScalableFreeformRootEditPart ep = new ScalableFreeformRootEditPart();
        this.viewer.setRootEditPart((RootEditPart)ep);
        DefaultEditDomain ded = new DefaultEditDomain(null);
        PanningSelectionTool pst = new PanningSelectionTool();
        ded.setDefaultTool((Tool)pst);
        ded.setActiveTool((Tool)pst);
        this.viewer.setEditDomain((EditDomain)ded);
        this.viewer.createControl((Composite)main);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.setEditPartFactory((EditPartFactory)this.getNodePartFactory());
        this.setGraphicalViewer((GraphicalViewer)this.viewer);
        this.viewer.setContextMenu(this.getContextMenuManager());
        GraphicalViewerKeyHandler keyHandler = new GraphicalViewerKeyHandler((GraphicalViewer)this.viewer);
        this.viewer.setKeyHandler((KeyHandler)keyHandler);
        if (this.toolbarPane != null) {
            this.toolbarPane.setGraphicalEditor(this);
        }
        this.hookGraphicalViewer();
        this.initializeGraphicalViewer();
    }

    public GraphicalViewer getViewer() {
        return this.viewer;
    }

    public NodeDiagramModel getModel() {
        return this.model;
    }

    public void setModel(NodeDiagramModel model) {
        this.model = model;
    }

    public void selectObject(Object obj) {
        if (obj == null) {
            return;
        }
        Node node = this.model.getModelObject(obj);
        assert (node != null);
        Object editpart = this.getViewer().getEditPartRegistry().get(node);
        if (editpart instanceof EditPart) {
            this.getViewer().select((EditPart)editpart);
            this.getViewer().reveal((EditPart)editpart);
        }
    }

    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class) {
            return this.getDiagramOutlinePage();
        }
        return super.getAdapter(type);
    }

    public void selectionOccurred(NodePart part) {
    }

    public void populateCanvasContextMenu(IMenuManager menuMgr) {
    }

    public void addZoomSubMenu(IMenuManager menuMgr) {
        MenuManager zoomMenuMgr = new MenuManager(DiagramActionMessages.zoomContextMenuText);
        zoomMenuMgr.setParent((IContributionManager)menuMgr);
        menuMgr.add((IContributionItem)zoomMenuMgr);
        ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)this.getViewer().getRootEditPart();
        ZoomManager zoomMgr = rootEditPart.getZoomManager();
        double zoomVal = zoomMgr.getZoom();
        boolean isFitToWindow = ZoomAction.FIT_TO_WINDOW.equals(this.getToolbarPane().getCurrentZoomLevel());
        ZoomAction za = new ZoomAction(this.getViewer(), this.getToolbarPane(), "&200%");
        za.setChecked(!isFitToWindow && zoomVal == 2.0);
        zoomMenuMgr.add((IAction)za);
        za = new ZoomAction(this.getViewer(), this.getToolbarPane(), "&150%");
        za.setChecked(!isFitToWindow && zoomVal == 1.5);
        zoomMenuMgr.add((IAction)za);
        za = new ZoomAction(this.getViewer(), this.getToolbarPane(), "1&00%");
        za.setChecked(!isFitToWindow && zoomVal == 1.0);
        zoomMenuMgr.add((IAction)za);
        za = new ZoomAction(this.getViewer(), this.getToolbarPane(), "&75%");
        za.setChecked(!isFitToWindow && zoomVal == 0.75);
        zoomMenuMgr.add((IAction)za);
        za = new ZoomAction(this.getViewer(), this.getToolbarPane(), "&50%");
        za.setChecked(!isFitToWindow && zoomVal == 0.5);
        zoomMenuMgr.add((IAction)za);
        za = new ZoomAction(this.getViewer(), this.getToolbarPane(), ZoomAction.FIT_TO_WINDOW_CONTEXT_MENU);
        za.setChecked(isFitToWindow);
        menuMgr.add((IAction)za);
    }

    protected DiagramOutlinePage getDiagramOutlinePage() {
        RootEditPart rootEditPart;
        if (this.outlinePage == null && this.getGraphicalViewer() != null && (rootEditPart = this.getGraphicalViewer().getRootEditPart()) instanceof ScalableFreeformRootEditPart) {
            this.outlinePage = new DiagramOutlinePage((ScalableFreeformRootEditPart)rootEditPart);
        }
        return this.outlinePage;
    }

    protected void enableZoomKeyBindings() {
        ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)this.getViewer().getRootEditPart();
        ZoomManager zoomManager = rootEditPart.getZoomManager();
        ZoomInAction zoomInAction = new ZoomInAction(zoomManager);
        ZoomOutAction zoomOutAction = new ZoomOutAction(zoomManager);
        IHandlerService service = (IHandlerService)this.getEditorSite().getService(IHandlerService.class);
        service.activateHandler(zoomInAction.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)zoomInAction));
        service.activateHandler(zoomOutAction.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)zoomOutAction));
    }

    public DiagramLinkStyle getLinkStyle() {
        return this.linkStyle;
    }

    public void setLinkStyle(DiagramLinkStyle newLinkStyle) {
        if (this.linkStyle != newLinkStyle) {
            this.linkStyle = newLinkStyle;
            EditPart ep = this.getViewer().getRootEditPart().getContents();
            assert (ep instanceof NodeDiagramPart);
            NodeDiagramPart diagramPart = (NodeDiagramPart)ep;
            List childParts = diagramPart.getChildren();
            for (Object obj : childParts) {
                NodeRelationshipPart relationPart;
                assert (obj instanceof RootNodePart);
                RootNodePart rootPart = (RootNodePart)((Object)obj);
                for (Object obj2 : rootPart.getSourceConnections()) {
                    relationPart = (NodeRelationshipPart)((Object)obj2);
                    relationPart.setLinkStyle(newLinkStyle);
                }
                for (Object obj3 : rootPart.getChildrenSourceConnections()) {
                    relationPart = (NodeRelationshipPart)((Object)obj3);
                    relationPart.setLinkStyle(newLinkStyle);
                }
            }
            diagramPart.getFigure().invalidate();
            diagramPart.getFigure().validate();
            if (this.getToolbarPane() != null) {
                this.getToolbarPane().updateToolbar();
            }
        }
    }

    public void refresh() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof NodeDiagramEditorInput) {
            NodeDiagramEditorInput diagramInput = (NodeDiagramEditorInput)editorInput;
            try {
                NodeDiagramModel model = diagramInput.refreshModel();
                this.setModel(model);
                this.getGraphicalViewer().setContents((Object)model);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

