/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.diagram.actions;

import oracle.eclipse.tools.common.ui.diagram.actions.DiagramActionMessages;
import oracle.eclipse.tools.common.ui.diagram.editor.NodeDiagramToolbarPane;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.jface.action.Action;

public class ZoomAction
extends Action {
    public static final String FIT_TO_WINDOW = DiagramActionMessages.fitToWindow;
    public static final String FIT_TO_WINDOW_CONTEXT_MENU = DiagramActionMessages.fitToWindowContextMenu;
    private final ZoomManager zoomManager;
    private final String zoomLevel;
    private final NodeDiagramToolbarPane toolbarPane;

    public ZoomAction(GraphicalViewer viewer, NodeDiagramToolbarPane toolbarPane, String zoomLevel) {
        assert (viewer != null);
        assert (zoomLevel != null);
        ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)viewer.getRootEditPart();
        this.zoomManager = rootEditPart.getZoomManager();
        this.toolbarPane = toolbarPane;
        this.zoomLevel = zoomLevel;
        this.setText(zoomLevel);
    }

    public void run() {
        if (this.zoomLevel.equals(FIT_TO_WINDOW) || this.zoomLevel.equals(FIT_TO_WINDOW_CONTEXT_MENU)) {
            this.zoomManager.setZoomAsText(ZoomManager.FIT_ALL);
            if (this.toolbarPane != null) {
                this.toolbarPane.setCurrentZoomLevel(FIT_TO_WINDOW);
            }
        } else {
            int ampIndex = this.zoomLevel.indexOf(38);
            String zl = ampIndex == -1 ? this.zoomLevel : String.valueOf(this.zoomLevel.substring(0, ampIndex)) + this.zoomLevel.substring(ampIndex + 1);
            this.zoomManager.setZoomAsText(zl);
            if (this.toolbarPane != null) {
                this.toolbarPane.setCurrentZoomLevel(zl);
            }
        }
    }
}

