/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.ui.diagram.actions;

import java.io.File;
import oracle.eclipse.tools.common.ui.diagram.actions.DiagramActionMessages;
import oracle.eclipse.tools.common.ui.internal.CommonUiPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GraphEditorExportToImageAction
extends Action {
    private static String _lastSelectedFolderLocation = null;
    private static final String BMP_EXTENSION = ".bmp";
    private static final String JPG_EXTENSION = ".jpg";
    private static final String[] IMAGE_TYPES = new String[]{".bmp", ".jpg"};
    private final GraphicalViewer _viewer;
    private final IFigure _mainFigure;
    private final IProject _project;
    private final String _defaultFileName;
    private static final String WIDGET_NAME_KEY = "name";
    public static final String WIDGET_NAME_LOCATION_TEXT = "LocationText";
    public static final String WIDGET_NAME_FILENAME_TEXT = "FileNameText";
    public static final String WIDGET_NAME_IMAGETYPE_COMBO = "ImageTypeCombo";

    public GraphEditorExportToImageAction(GraphicalViewer viewer, IFigure mainFigure, IProject project, String defaultFileName) {
        if (viewer == null) {
            throw new IllegalArgumentException("viewer cannot be null");
        }
        if (mainFigure == null) {
            throw new IllegalArgumentException("mainFigure cannot be null");
        }
        this._viewer = viewer;
        this._project = project;
        this._mainFigure = mainFigure;
        this._defaultFileName = defaultFileName;
        this.setText(DiagramActionMessages.exportContextMenuText);
        this.setImageDescriptor(CommonUiPlugin.Images.EXPORT_IMAGE.getImageDescriptor());
    }

    public void run() {
        SaveAsImageDialog dlg = new SaveAsImageDialog();
        dlg.create();
        if (dlg.open() == 0) {
            _lastSelectedFolderLocation = dlg._folderLocation;
            this.exportToFile(dlg.getFullyQualifiedFileName());
        }
    }

    private void exportToFile(String fileName) {
        int width = -1;
        int height = -1;
        Rectangle bounds = this._mainFigure.getBounds();
        width = bounds.width;
        height = bounds.height;
        Display display = Display.getDefault();
        Image image = new Image((Device)display, width, height);
        GC graphicContext = new GC((Drawable)image);
        SWTGraphics graphics = new SWTGraphics(graphicContext);
        LayerManager lm = (LayerManager)this._viewer.getEditPartRegistry().get(LayerManager.ID);
        IFigure f = lm.getLayer((Object)"Printable Layers");
        f.paint((Graphics)graphics);
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{image.getImageData()};
        imageLoader.logicalScreenWidth = width;
        imageLoader.logicalScreenHeight = height;
        try {
            if (fileName.endsWith(JPG_EXTENSION)) {
                imageLoader.save(fileName, 4);
            } else if (fileName.endsWith(BMP_EXTENSION)) {
                imageLoader.save(fileName, 0);
            } else assert (false) : "Unexpected image format for file: " + fileName;
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static final boolean hasInvalidChars(String path) {
        char[] invChars = new char[]{'!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '+', '=', '<', '>', '?', '~', ';'};
        int i = 0;
        while (i < invChars.length) {
            if (path.indexOf(invChars[i]) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private class SaveAsImageDialog
    extends StatusDialog {
        private Button _browseButton;
        private Text _fileNameText;
        private Combo _imageTypeCombo;
        private Text _locationText;
        private boolean _hasFilenameBeenModified;
        private String _fileName;
        private String _folderLocation;

        private SaveAsImageDialog() {
            super(Display.getDefault().getActiveShell());
            this._fileName = null;
            this._folderLocation = null;
            this.setTitle(DiagramActionMessages.exportShellTitle);
            this.setHelpAvailable(false);
            this._hasFilenameBeenModified = GraphEditorExportToImageAction.this._defaultFileName != null && GraphEditorExportToImageAction.this._defaultFileName.length() != 0;
        }

        protected Control createDialogArea(Composite parent) {
            Composite parentComposite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(3, false);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            parentComposite.setLayout((Layout)layout);
            parentComposite.setLayoutData((Object)new GridData(1808));
            SaveAsImageDialog.applyDialogFont((Control)parentComposite);
            Label label = new Label(parentComposite, 0);
            label.setText(DiagramActionMessages.exportLocationLabelText);
            this._locationText = new Text(parentComposite, 2048);
            this._locationText.setData(GraphEditorExportToImageAction.WIDGET_NAME_KEY, (Object)GraphEditorExportToImageAction.WIDGET_NAME_LOCATION_TEXT);
            boolean lastLocationExists = false;
            if (_lastSelectedFolderLocation != null) {
                File f = new File(_lastSelectedFolderLocation);
                lastLocationExists = f.exists();
            }
            String location = _lastSelectedFolderLocation == null || !lastLocationExists ? (GraphEditorExportToImageAction.this._project != null ? GraphEditorExportToImageAction.this._project.getLocation().toOSString() : "") : _lastSelectedFolderLocation;
            this._locationText.setText(location);
            this._locationText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SaveAsImageDialog.this.validate();
                }
            });
            GridData gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            gd.widthHint = 260;
            this._locationText.setLayoutData((Object)gd);
            this._browseButton = new Button(parentComposite, 8);
            this._browseButton.setText(DiagramActionMessages.exportBrowseButtonText);
            this._browseButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog dd = new DirectoryDialog(SaveAsImageDialog.this.getShell());
                    dd.setFilterPath(SaveAsImageDialog.this._locationText.getText());
                    String dir = dd.open();
                    if (dir != null) {
                        SaveAsImageDialog.this._locationText.setText(dir);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            label = new Label(parentComposite, 0);
            label.setText(DiagramActionMessages.fileNameLabelText);
            this._fileNameText = new Text(parentComposite, 2048);
            this._fileNameText.setData(GraphEditorExportToImageAction.WIDGET_NAME_KEY, (Object)GraphEditorExportToImageAction.WIDGET_NAME_FILENAME_TEXT);
            this._fileNameText.setText(GraphEditorExportToImageAction.this._defaultFileName);
            this._fileNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SaveAsImageDialog.this._hasFilenameBeenModified = true;
                    SaveAsImageDialog.this.validate();
                }
            });
            gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            gd.horizontalSpan = 2;
            this._fileNameText.setLayoutData((Object)gd);
            label = new Label(parentComposite, 0);
            label.setText(DiagramActionMessages.imageTypeLabelText);
            this._imageTypeCombo = new Combo(parentComposite, 2060);
            this._imageTypeCombo.setData(GraphEditorExportToImageAction.WIDGET_NAME_KEY, (Object)GraphEditorExportToImageAction.WIDGET_NAME_IMAGETYPE_COMBO);
            gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            gd.horizontalSpan = 2;
            this._imageTypeCombo.setLayoutData((Object)gd);
            String[] stringArray = IMAGE_TYPES;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this._imageTypeCombo.add(s);
                ++n2;
            }
            this._imageTypeCombo.select(0);
            this._imageTypeCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SaveAsImageDialog.this.validate();
                }
            });
            return parentComposite;
        }

        protected void validate() {
            String location = this._locationText.getText();
            if (location == null || location.trim().length() == 0) {
                Status status = new Status(4, "oracle.eclipse.tools.common.ui", 0, DiagramActionMessages.locationRequiredMsg, null);
                this.updateStatus((IStatus)status);
                return;
            }
            File f = new File(location);
            if (!f.exists()) {
                Status status = new Status(4, "oracle.eclipse.tools.common.ui", 0, DiagramActionMessages.invalidLocationMsg, null);
                this.updateStatus((IStatus)status);
                return;
            }
            String filename = this._fileNameText.getText();
            if (filename == null || filename.trim().length() == 0) {
                Status status = null;
                status = this._hasFilenameBeenModified ? new Status(4, "oracle.eclipse.tools.common.ui", 0, DiagramActionMessages.fileNameRequiredMsg, null) : new Status(1, "oracle.eclipse.tools.common.ui", 0, "", null);
                this.updateStatus((IStatus)status);
                return;
            }
            if (GraphEditorExportToImageAction.hasInvalidChars(filename)) {
                Status status = new Status(4, "oracle.eclipse.tools.common.ui", 0, DiagramActionMessages.invalidFileNameMsg, null);
                this.updateStatus((IStatus)status);
                return;
            }
            this.updateStatus((IStatus)new Status(0, "oracle.eclipse.tools.common.ui", ""));
        }

        protected void okPressed() {
            boolean okPressed;
            this._folderLocation = this._locationText.getText();
            StringBuffer sb = new StringBuffer(this._folderLocation);
            if (!this._folderLocation.endsWith("/") || !this._folderLocation.endsWith("\\")) {
                sb.append(File.separator);
            }
            String fn = this._fileNameText.getText();
            sb.append(fn);
            String ext = this._imageTypeCombo.getText();
            if (!fn.endsWith(ext)) {
                sb.append(ext);
            }
            this._fileName = sb.toString();
            if (new File(this._fileName).exists() && !(okPressed = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)DiagramActionMessages.imageFileExistsTitle, (String)DiagramActionMessages.imageFileExistsMsg))) {
                this._fileNameText.setFocus();
                return;
            }
            super.okPressed();
        }

        public String getFullyQualifiedFileName() {
            return this._fileName;
        }
    }
}

