/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.struts.ui.util;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.struts.ui.internal.StrutsUiPlugin;
import oracle.eclipse.tools.webtier.struts.ui.util.FacetUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.osgi.framework.Bundle;

public class StrutsUtil {
    public static final String TEMPLATES_FOLDER = "templates/";
    public static final String[] jspFiles = new String[]{"index.jsp", "pages/welcome.jsp"};
    public static final String[] configFiles = new String[]{"WEB-INF/config/struts-config.xml", "WEB-INF/config/tiles-defs.xml", "WEB-INF/config/validation.xml", "WEB-INF/config/validator-rules.xml"};

    public static StrutsVersion getStrutsVersion(IProjectFacetVersion fv) {
        String version = fv.getVersionString();
        if (version.startsWith("1.3")) {
            return StrutsVersion.STRUTS_1_3;
        }
        if (version.startsWith("1.2")) {
            return StrutsVersion.STRUTS_1_2;
        }
        return StrutsVersion.STRUTS_1_1;
    }

    public static String getTemplatesFolderName(IProjectFacetVersion fv) {
        String folderName = null;
        StrutsVersion strutsVersion = StrutsUtil.getStrutsVersion(fv);
        if (strutsVersion == StrutsVersion.STRUTS_1_1) {
            folderName = "new-web-app-1.1";
        } else if (strutsVersion == StrutsVersion.STRUTS_1_2) {
            folderName = "new-web-app-1.2";
        } else if (strutsVersion == StrutsVersion.STRUTS_1_3) {
            folderName = "new-web-app-1.3";
        } else {
            LoggingService.logError((String)"oracle.eclipse.tools.webtier.struts.ui", (String)"Unsupported struts facet version. Struts 1.1-1.3 are supported.");
        }
        return folderName;
    }

    public static String getResourceBundleName(IProjectFacetVersion fv) {
        String resourceBundleToDelete = null;
        resourceBundleToDelete = StrutsUtil.getStrutsVersion(fv) == StrutsVersion.STRUTS_1_1 ? "resources/application.properties" : "MessageResources.properties";
        return resourceBundleToDelete;
    }

    public static void addFilenameArrayToIFileList(String[] filenamesToDelete, List<IFile> iFileList, IProject project, String filenamePrefix) {
        String[] stringArray = filenamesToDelete;
        int n = filenamesToDelete.length;
        int n2 = 0;
        while (n2 < n) {
            String filenameToDelete = stringArray[n2];
            IFile iFile = project.getFile(String.valueOf(filenamePrefix) + filenameToDelete);
            if (iFile.isAccessible()) {
                iFileList.add(iFile);
            }
            ++n2;
        }
    }

    public static File getTemplateFile(IFile ifileToWrite, IProjectFacetVersion fv) throws IOException, URISyntaxException {
        String newWebAppFolderName = StrutsUtil.getTemplatesFolderName(fv);
        HashMap<String, String> templateFileMap = new HashMap<String, String>();
        templateFileMap.put("index.jsp", "templates/new-app/" + newWebAppFolderName + "/web/index.jsp");
        templateFileMap.put("welcome.jsp", "templates/new-app/" + newWebAppFolderName + "/web/pages/welcome.jsp");
        templateFileMap.put("struts-config.xml", "templates/new-app/" + newWebAppFolderName + "/web/WEB-INF/config/struts-config.xml");
        templateFileMap.put("tiles-defs.xml", "templates/new-app/" + newWebAppFolderName + "/web/WEB-INF/config/tiles-defs.xml");
        templateFileMap.put("validation.xml", "templates/new-app/" + newWebAppFolderName + "/web/WEB-INF/config/validation.xml");
        templateFileMap.put("validator-rules.xml", "templates/new-app/" + newWebAppFolderName + "/web/WEB-INF/config/validator-rules.xml");
        templateFileMap.put("MessageResources.properties", "templates/new-app/" + newWebAppFolderName + "/src/MessageResources.properties");
        templateFileMap.put("application.properties", "templates/new-app/" + newWebAppFolderName + "/src/resources/application.properties");
        String templateFileRelativePath = (String)templateFileMap.get(ifileToWrite.getName());
        if (templateFileRelativePath == null) {
            throw new IllegalArgumentException("Template file not found in map.");
        }
        Bundle bundle = StrutsUiPlugin.getDefault().getBundle();
        URL bundleUrl = bundle.getEntry(templateFileRelativePath);
        URL fileUrl = FileLocator.toFileURL((URL)bundleUrl);
        File fileToCopy = new File(fileUrl.toURI());
        return fileToCopy;
    }

    public static List<IFile> getExistingTemplateFilesInProject(IProject project, IProjectFacetVersion fv) {
        ArrayList<IFile> iFilesToOverwrite = new ArrayList<IFile>();
        try {
            String WEB_CONTENT_FOLDER_NAME = FacetUtil.getWebContentFolderName(project);
            StrutsUtil.addFilenameArrayToIFileList(jspFiles, iFilesToOverwrite, project, String.valueOf(WEB_CONTENT_FOLDER_NAME) + "/");
            StrutsUtil.addFilenameArrayToIFileList(configFiles, iFilesToOverwrite, project, String.valueOf(WEB_CONTENT_FOLDER_NAME) + "/");
        }
        catch (CoreException e) {
            LoggingService.logError((String)"oracle.eclipse.tools.webtier.struts.ui", (String)e.getLocalizedMessage());
        }
        String[] resourceBundlesToDelete = new String[]{StrutsUtil.getResourceBundleName(fv)};
        StrutsUtil.addFilenameArrayToIFileList(resourceBundlesToDelete, iFilesToOverwrite, project, "src/");
        return iFilesToOverwrite;
    }

    public static enum StrutsVersion {
        STRUTS_1_1,
        STRUTS_1_2,
        STRUTS_1_3;

    }
}

