/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.struts.ui.internal;

import java.util.List;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.webtier.common.services.facet.FacetTemplatesHelper;
import oracle.eclipse.tools.webtier.common.services.facet.ui.ConfirmFileDeleteDialog;
import oracle.eclipse.tools.webtier.common.services.util.FacetUtil;
import oracle.eclipse.tools.webtier.struts.ui.internal.Messages;
import oracle.eclipse.tools.webtier.struts.ui.internal.StrutsFacetTemplatesHelper;
import oracle.eclipse.tools.webtier.struts.ui.util.StrutsUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryFacetUninstallConfig;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.internal.impl.ServletTypeImpl;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.internal.impl.WebAppImpl;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class StrutsFacetUninstallDelegate
implements IDelegate {
    private static final String SERVLET_NAME = "org.apache.struts.action.ActionServlet";
    private static final IPath WEB_XML_PATH = new Path("WEB-INF").append("web.xml");

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (String)"", (int)2);
        try {
            this.removeLibraries(config, monitor);
            this.updateWebXml(project, monitor);
            this.deleteFiles(project, fv, monitor);
            oracle.eclipse.tools.webtier.struts.ui.util.FacetUtil.refreshProject(project);
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    private void removeLibraries(Object config, IProgressMonitor monitor) throws CoreException {
        LibraryFacetUninstallConfig cfg = (LibraryFacetUninstallConfig)config;
        cfg.getLibraryUninstallDelegate().execute(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
    }

    private void updateWebXml(IProject project, IProgressMonitor monitor) {
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
        Object webAppObj = provider.getModelObject();
        if (webAppObj != null) {
            if (webAppObj instanceof WebAppImpl) {
                this.updateWebXmlforJavaEE(webAppObj, project, provider, monitor);
            } else if (webAppObj instanceof org.eclipse.jst.j2ee.webapplication.internal.impl.WebAppImpl) {
                this.updateWebXmlforJ2EE(webAppObj, project, provider, monitor);
            }
        }
    }

    private void deleteFiles(IProject project, IProjectFacetVersion fv, IProgressMonitor monitor) {
        if (FacetUtil.areDialogsEnabled()) {
            ConfirmFileDeleteDialog dialog = new ConfirmFileDeleteDialog(project, fv, monitor, (FacetTemplatesHelper)new StrutsFacetTemplatesHelper(project, fv));
            dialog.execute(Messages.StrutsFacetUninstallDelegate_DeleteConfirmationDialogTitle, Messages.StrutsFacetUninstallDelegate_DeleteConfirmationDialogDescription);
        } else {
            FacetUtil.deleteIFiles((IProject)project, (IProjectFacetVersion)fv, (IProgressMonitor)monitor, StrutsUtil.getExistingTemplateFilesInProject(project, fv));
        }
    }

    private void updateWebXmlforJavaEE(Object webAppObj, IProject project, IModelProvider provider, IProgressMonitor monitor) {
        WebApp webApp = (WebApp)webAppObj;
        org.eclipse.jst.javaee.web.Servlet servlet = StrutsFacetUninstallDelegate.findServletForJavaEE(webApp);
        if (servlet == null) {
            return;
        }
        provider.modify((Runnable)new WebXmlUpdaterForJavaEE(project), WEB_XML_PATH);
    }

    private void updateWebXmlforJ2EE(Object webAppObj, IProject project, IModelProvider provider, IProgressMonitor monitor) {
        org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj;
        Servlet servlet = StrutsFacetUninstallDelegate.findServletForJ2EE(webApp);
        if (servlet == null) {
            return;
        }
        provider.modify((Runnable)new WebXmlUpdaterForJ2EE(project), WEB_XML_PATH);
    }

    private static org.eclipse.jst.javaee.web.Servlet findServletForJavaEE(WebApp webApp) {
        for (Object servlet : webApp.getServlets()) {
            if (!((org.eclipse.jst.javaee.web.Servlet)servlet).getServletClass().trim().equals(SERVLET_NAME)) continue;
            return (org.eclipse.jst.javaee.web.Servlet)servlet;
        }
        return null;
    }

    private static Servlet findServletForJ2EE(org.eclipse.jst.j2ee.webapplication.WebApp webApp) {
        for (Object servlet : webApp.getServlets()) {
            Servlet j2eeServlet = (Servlet)servlet;
            String servletClass = ((ServletTypeImpl)j2eeServlet.getWebType()).getClassName();
            if (!servletClass.equals(SERVLET_NAME)) continue;
            return j2eeServlet;
        }
        return null;
    }

    private static class WebXmlUpdaterForJ2EE
    implements Runnable {
        private final IProject project;

        WebXmlUpdaterForJ2EE(IProject project) {
            this.project = project;
        }

        @Override
        public void run() {
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)ModelProviderManager.getModelProvider((IProject)this.project).getModelObject();
            Servlet servlet = StrutsFacetUninstallDelegate.findServletForJ2EE(webApp);
            WebXmlUpdaterForJ2EE.removeServletMappings(webApp, servlet);
            WebXmlUpdaterForJ2EE.removeServlet(webApp, servlet);
        }

        private static void removeServlet(org.eclipse.jst.j2ee.webapplication.WebApp webApp, Servlet servlet) {
            webApp.getServlets().remove((Object)servlet);
        }

        private static void removeServletMappings(org.eclipse.jst.j2ee.webapplication.WebApp webApp, Servlet servlet) {
            EList mappings = webApp.getServletMappings();
            String servletName = servlet.getServletName();
            if (servletName != null) {
                servletName = servletName.trim();
                int i = mappings.size() - 1;
                while (i >= 0) {
                    org.eclipse.jst.j2ee.webapplication.ServletMapping mapping = (org.eclipse.jst.j2ee.webapplication.ServletMapping)mappings.get(i);
                    if (mapping != null && mapping.getServlet().getServletName() != null && mapping.getServlet().getServletName().trim().equals(servletName)) {
                        mappings.remove(mapping);
                    }
                    --i;
                }
            }
        }
    }

    private static class WebXmlUpdaterForJavaEE
    implements Runnable {
        private final IProject project;

        WebXmlUpdaterForJavaEE(IProject project) {
            this.project = project;
        }

        @Override
        public void run() {
            WebApp webApp = (WebApp)ModelProviderManager.getModelProvider((IProject)this.project).getModelObject();
            org.eclipse.jst.javaee.web.Servlet servlet = StrutsFacetUninstallDelegate.findServletForJavaEE(webApp);
            WebXmlUpdaterForJavaEE.removeServletMappings(webApp, servlet);
            WebXmlUpdaterForJavaEE.removeServlet(webApp, servlet);
        }

        private static void removeServlet(WebApp webApp, org.eclipse.jst.javaee.web.Servlet servlet) {
            webApp.getServlets().remove(servlet);
        }

        private static void removeServletMappings(WebApp webApp, org.eclipse.jst.javaee.web.Servlet servlet) {
            List mappings = webApp.getServletMappings();
            String servletName = servlet.getServletName();
            if (servletName != null) {
                servletName = servletName.trim();
                int i = mappings.size() - 1;
                while (i >= 0) {
                    ServletMapping mapping = (ServletMapping)mappings.get(i);
                    if (mapping != null && mapping.getServletName() != null && mapping.getServletName().trim().equals(servletName)) {
                        mappings.remove(mapping);
                    }
                    --i;
                }
            }
        }
    }
}

