/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.syslib.internal;

import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerInstall;
import oracle.eclipse.tools.weblogic.syslib.ISystemLibrariesContainerDef;
import oracle.eclipse.tools.weblogic.syslib.SystemLibrariesContainer;
import oracle.eclipse.tools.weblogic.ui.internal.WlsUiPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphireForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class SystemLibrariesContainerPage
extends NewElementWizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private IProject project;
    private WebLogicServerInstall wlsInstall;
    private ISystemLibrariesContainerDef model;
    private IClasspathEntry classpathEntry;

    public SystemLibrariesContainerPage() {
        super(Resources.title);
        this.setTitle(Resources.title);
        this.setDescription(Resources.description);
        this.setImageDescriptor(JavaPluginImages.DESC_WIZBAN_ADD_LIBRARY);
    }

    public void initialize(IJavaProject jproject, IClasspathEntry[] cp) {
        this.project = jproject.getProject();
    }

    public IClasspathEntry getSelection() {
        return this.classpathEntry;
    }

    public void setSelection(IClasspathEntry cpe) {
        this.classpathEntry = cpe == null ? JavaCore.newContainerEntry((IPath)SystemLibrariesContainer.CONTAINER_PATH) : cpe;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.wlsInstall = WebLogicServerInstall.getWebLogicServerInstall((IProject)this.project);
        if (this.wlsInstall != null && this.wlsInstall.isValid()) {
            composite.setLayout((Layout)SwtUtil.glayout((int)1));
            try {
                this.model = SystemLibrariesContainer.getContainerDef((IProject)this.project);
            }
            catch (ResourceStoreException e) {
                WlsUiPlugin.log((Exception)((Object)e));
            }
            SapphireForm sysLibPanel = new SapphireForm(composite, (Element)this.model, DefinitionLoader.sdef(((Object)((Object)this)).getClass()).form());
            sysLibPanel.setLayoutData((Object)SwtUtil.gdhfill());
            final Runnable messageUpdateOperation = new Runnable(){

                @Override
                public void run() {
                    Status valResult = SystemLibrariesContainerPage.this.model.validation();
                    SystemLibrariesContainerPage.this.updateStatus(StatusBridge.create((Status)valResult));
                    if (valResult.ok()) {
                        SystemLibrariesContainerPage.this.setMessage(null);
                    }
                }
            };
            messageUpdateOperation.run();
            FilteredListener<PropertyValidationEvent> messageUpdateListener = new FilteredListener<PropertyValidationEvent>(){

                protected void handleTypedEvent(PropertyValidationEvent event) {
                    Display.getCurrent().asyncExec(messageUpdateOperation);
                }
            };
            this.model.attach((Listener)messageUpdateListener, "*");
            composite.addDisposeListener(new DisposeListener((Listener)messageUpdateListener){
                private final /* synthetic */ Listener val$messageUpdateListener;
                {
                    this.val$messageUpdateListener = listener;
                }

                public void widgetDisposed(DisposeEvent event) {
                    SystemLibrariesContainerPage.this.model.detach(this.val$messageUpdateListener, "*");
                }
            });
        } else {
            String msg = this.wlsInstall == null ? Resources.cannotUseWithThisProjectMessage : Resources.invalidInstallMessage;
            composite.setLayout((Layout)SwtUtil.glayout((int)1));
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)SwtUtil.gdhfill());
            label.setText(msg);
            this.updateStatus(WlsUiPlugin.createErrorStatus(msg));
        }
        this.setControl((Control)composite);
    }

    public boolean finish() {
        try {
            this.model.resource().save();
        }
        catch (Exception e) {
            WlsUiPlugin.logException(e);
        }
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.getControl().getShell().setSize(600, 550);
            if (this.model != null && this.model.validation().ok()) {
                this.setMessage(null);
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String title;
        public static String description;
        public static String cannotUseWithThisProjectMessage;
        public static String invalidInstallMessage;

        static {
            Resources.initializeMessages((String)(String.valueOf(SystemLibrariesContainerPage.class.getName()) + "Ext"), Resources.class);
        }

        private Resources() {
        }
    }
}

