/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.server.remote;

import java.util.List;
import oracle.eclipse.tools.weblogic.server.internal.util.FacetUtil;
import oracle.eclipse.tools.weblogic.server.model.IWeblogicDeployableModule;
import oracle.eclipse.tools.weblogic.server.model.IWeblogicModule;
import oracle.eclipse.tools.weblogic.ui.export.internal.WLSExportOperation;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.j2ee.application.internal.operations.EARComponentExportDataModelProvider;
import org.eclipse.jst.j2ee.internal.archive.operations.JavaEEComponentExportOperation;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.PublishOperation;

public class ExportArchivesOperation
extends PublishOperation {
    public ExportArchivesOperation(IServer server) {
    }

    public void execute(IProgressMonitor monitor, IAdaptable info) throws CoreException {
        List modules = (List)this.getTaskModel().getObject("weblogic_modules");
        for (IWeblogicModule wm : modules) {
            if (wm.getKind() == 3) continue;
            IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new EARComponentExportDataModelProvider());
            String projName = wm.getModule().getProject().getName();
            model.setStringProperty("IJ2EEComponentExportDataModelProperties.PROJECT_NAME", projName);
            IWeblogicDeployableModule wdm = (IWeblogicDeployableModule)wm;
            String ext = FacetUtil.getResourceExtension((IProject)wm.getModule().getProject());
            String earPath = String.valueOf(wdm.getDeploymentPath().toString()) + ext;
            model.setStringProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION", earPath);
            IVirtualComponent comp = ComponentCore.createComponent((IProject)wm.getModule().getProject());
            model.setProperty("IJ2EEComponentExportDataModelProperties.COMPONENT", (Object)comp);
            try {
                if (".war".equals(ext)) {
                    this.exportWar(monitor, model);
                    continue;
                }
                if (".ear".equals(ext)) {
                    this.exportEar(monitor, model);
                    continue;
                }
                if (".gar".equals(ext)) {
                    this.exportCoherenceGar(monitor, model);
                    continue;
                }
                this.exportEjbJar(monitor, model);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    private void exportEar(IProgressMonitor monitor, IDataModel model) throws ExecutionException {
        WLSExportOperation.EarExportPreOperation preOp = new WLSExportOperation.EarExportPreOperation();
        preOp.setDataModel(model);
        preOp.execute(monitor, null);
        JavaEEComponentExportOperation exportOp = new JavaEEComponentExportOperation(model);
        exportOp.execute(monitor, null);
        WLSExportOperation.EarExportPostOperation postOp = new WLSExportOperation.EarExportPostOperation();
        postOp.setDataModel(model);
        postOp.execute(monitor, null);
    }

    private void exportWar(IProgressMonitor monitor, IDataModel model) throws ExecutionException {
        WLSExportOperation.WarExportPreOperation preOp = new WLSExportOperation.WarExportPreOperation();
        preOp.setDataModel(model);
        preOp.execute(monitor, null);
        JavaEEComponentExportOperation exportOp = new JavaEEComponentExportOperation(model);
        exportOp.execute(monitor, null);
        WLSExportOperation.WarExportPostOperation postOp = new WLSExportOperation.WarExportPostOperation();
        postOp.setDataModel(model);
        postOp.execute(monitor, null);
    }

    private void exportEjbJar(IProgressMonitor monitor, IDataModel model) throws ExecutionException {
        WLSExportOperation.EjbExportPreOperation preOp = new WLSExportOperation.EjbExportPreOperation();
        preOp.setDataModel(model);
        preOp.execute(monitor, null);
        JavaEEComponentExportOperation exportOp = new JavaEEComponentExportOperation(model);
        exportOp.execute(monitor, null);
        WLSExportOperation.EjbExportPostOperation postOp = new WLSExportOperation.EjbExportPostOperation();
        postOp.setDataModel(model);
        postOp.execute(monitor, null);
    }

    private void exportCoherenceGar(IProgressMonitor monitor, IDataModel model) throws ExecutionException {
        WLSExportOperation.GarExportPreOperation preOp = new WLSExportOperation.GarExportPreOperation();
        preOp.setDataModel(model);
        preOp.execute(monitor, null);
        JavaEEComponentExportOperation exportOp = new JavaEEComponentExportOperation(model);
        exportOp.execute(monitor, null);
        WLSExportOperation.GarExportPostOperation postOp = new WLSExportOperation.GarExportPostOperation();
        postOp.setDataModel(model);
        postOp.execute(monitor, null);
    }

    public int getKind() {
        return 2;
    }

    public int getOrder() {
        return 500;
    }
}

