/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.server.internal.property;

import oracle.eclipse.tools.weblogic.server.IJ2EEDeploymentHelper;
import oracle.eclipse.tools.weblogic.server.IWlsJMXHelper;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerBehaviour;
import oracle.eclipse.tools.weblogic.server.properties.IWebLogicServerModel;
import oracle.eclipse.tools.weblogic.ui.server.internal.property.WeblogicPropertyPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerEvent;

public class ServerPropertyPage
extends WeblogicPropertyPage {
    private IServerListener serverListener = null;

    protected Control createContents(Composite parent) {
        try {
            Composite composite = (Composite)super.createContents(parent);
            if (this.getWeblogicServer().isRemote()) {
                this.serverListener = new IServerListener(){

                    public void serverChanged(ServerEvent event) {
                        ServerPropertyPage.this.refreshRemoteConfiguration();
                    }
                };
                this.server.addServerListener(this.serverListener);
            }
            this.refreshRemoteConfiguration();
            composite.layout(true);
            return composite;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.serverListener != null) {
            this.server.removeServerListener(this.serverListener);
        }
    }

    private void refreshRemoteConfiguration() {
        UIJob job = new UIJob("Updating"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWebLogicServerModel model = (IWebLogicServerModel)ServerPropertyPage.this.element();
                if (model == null) {
                    return Status.OK_STATUS;
                }
                model.setServerDisconnected(Boolean.valueOf(ServerPropertyPage.this.server.getServerState() != 2));
                if (ServerPropertyPage.this.server.getServerState() != 2) {
                    return Status.OK_STATUS;
                }
                WeblogicServerBehaviour behavior = (WeblogicServerBehaviour)ServerPropertyPage.this.server.loadAdapter(WeblogicServerBehaviour.class, null);
                if (behavior == null) {
                    return Status.OK_STATUS;
                }
                IJ2EEDeploymentHelper helper = behavior.getPublisher();
                if (helper == null) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    String domainName = helper.getDomainName();
                    IWlsJMXHelper JMXHelper = helper.getWlsJMXHelper();
                    String adminServer = JMXHelper.getAdminServerName();
                    model.setDomainName(domainName);
                    model.setAdminServer(adminServer);
                }
                catch (CoreException coreException) {}
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

