/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.server.internal.cnf.modules;

import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRegistry;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModulesSvc;
import oracle.eclipse.tools.weblogic.server.modules.JavaEEModule;
import oracle.eclipse.tools.weblogic.server.modules.PublishedModule;
import oracle.eclipse.tools.weblogic.server.modules.PublishedModuleTarget;
import oracle.eclipse.tools.weblogic.server.modules.PublishedModulesRoot;
import oracle.eclipse.tools.weblogic.server.modules.SharedLibraryRoot;
import oracle.eclipse.tools.weblogic.server.modules.WebServiceNode;
import oracle.eclipse.tools.weblogic.ui.internal.WlsUiPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class PublishedModulesLabelProvider
extends LabelProvider {
    private LibraryModuleRegistry.IListener sharedLibraryRegistryListener = new LibraryModuleRegistry.IListener(){

        public void registryChanged() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PublishedModulesLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)PublishedModulesLabelProvider.this));
                }
            });
        }
    };

    public PublishedModulesLabelProvider() {
        LibraryModulesSvc.getRegistry().addListener(this.sharedLibraryRegistryListener);
    }

    public String getText(Object element) {
        if (element instanceof PublishedModulesRoot) {
            return Resources.publishedModules;
        }
        if (element instanceof SharedLibraryRoot) {
            return Resources.sharedLibraries;
        }
        if (element instanceof WebServiceNode) {
            WebServiceNode node = (WebServiceNode)element;
            String name = node.label();
            int n = name.indexOf(33);
            if (n > 0) {
                name = name.substring(n + 1);
            }
            return name;
        }
        if (element instanceof PublishedModule) {
            PublishedModule module = (PublishedModule)element;
            String name = module.label();
            if (name.endsWith("/") && !name.equals("/")) {
                name = name.substring(0, name.length() - 1);
            }
            return name;
        }
        return null;
    }

    public ImageDescriptor image(JavaEEModule element) {
        String type = element.getType();
        if (type.equalsIgnoreCase("war")) {
            return WlsUiPlugin.IMG_DESC_WEB_MODULE_INACTIVE;
        }
        if (type.equalsIgnoreCase("ejb")) {
            return WlsUiPlugin.IMG_DESC_EJB_MODULE_INACTIVE;
        }
        if (type.equalsIgnoreCase("ear")) {
            return WlsUiPlugin.IMG_DESC_EAR_MODULE_INACTIVE;
        }
        if (type.equalsIgnoreCase("gar")) {
            return WlsUiPlugin.IMG_DESC_GAR_MODULE;
        }
        if (type.equalsIgnoreCase("ws")) {
            return WlsUiPlugin.IMG_DESC_WEB_SERVICE;
        }
        return WlsUiPlugin.IMG_DESC_EAR_MODULE_INACTIVE;
    }

    public Image getImage(Object element) {
        ImageDescriptor descriptor = null;
        if (element instanceof PublishedModulesRoot) {
            descriptor = WlsUiPlugin.IMG_DESC_PUBLISHED_MODULES;
        } else if (element instanceof PublishedModuleTarget) {
            descriptor = WlsUiPlugin.IMG_DESC_ADMIN_SERVER;
        } else if (element instanceof SharedLibraryRoot) {
            descriptor = WlsUiPlugin.IMG_DESC_PUBLISHED_MODULES;
        } else if (element instanceof JavaEEModule) {
            descriptor = this.image((JavaEEModule)element);
        }
        if (descriptor != null) {
            return CommonImages.createImage((ImageDescriptor)descriptor);
        }
        return null;
    }

    public void dispose() {
        if (this.sharedLibraryRegistryListener != null) {
            LibraryModulesSvc.getRegistry().removeListener(this.sharedLibraryRegistryListener);
            this.sharedLibraryRegistryListener = null;
        }
        super.dispose();
    }

    private static final class Resources
    extends NLS {
        public static String publishedModules;
        public static String sharedLibraries;

        static {
            Resources.initializeMessages((String)PublishedModulesLabelProvider.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

