/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.server.internal.cnf.modules;

import java.net.URL;
import oracle.eclipse.tools.weblogic.server.modules.PublishedModule;
import oracle.eclipse.tools.weblogic.server.modules.PublishedModuleTarget;
import oracle.eclipse.tools.weblogic.server.modules.PublishedModulesRoot;
import oracle.eclipse.tools.weblogic.server.modules.SharedLibraryRoot;
import oracle.eclipse.tools.weblogic.server.modules.WebServiceNode;
import oracle.eclipse.tools.weblogic.ui.server.internal.cnf.WeblogicCommonActionProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class PublishedModulesActionProvider
extends WeblogicCommonActionProvider {
    protected Action showLibraryModulesAction;
    protected Action showEjbModulesAction;
    protected Action showWebModulesAction;
    protected Action showEarModulesAction;
    protected UndeployModuleAction undeployAction;
    private static final String DOMAIN_NAV_CONTENT_EXT_ID = "oracle.eclipse.tools.weblogic.server.ui.ServersView.content.publishedModules";

    @Override
    public void init(ICommonActionExtensionSite aSite) {
        StructuredViewer v;
        super.init(aSite);
        ICommonViewerSite site = aSite.getViewSite();
        if (site instanceof ICommonViewerWorkbenchSite && (v = aSite.getStructuredViewer()) instanceof CommonViewer) {
            CommonViewer cv = (CommonViewer)v;
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            this.makeActions(cv, wsSite.getSelectionProvider());
        }
    }

    private void makeActions(CommonViewer cv, ISelectionProvider selectionProvider) {
        this.undeployAction = new UndeployModuleAction();
    }

    @Override
    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
    }

    @Override
    public void fillContextMenu(IMenuManager menu) {
        ICommonViewerWorkbenchSite wsSite;
        super.fillContextMenu(menu);
        ICommonViewerSite site = this.getActionSite().getViewSite();
        IStructuredSelection selection = null;
        if (site instanceof ICommonViewerWorkbenchSite && (selection = (IStructuredSelection)(wsSite = (ICommonViewerWorkbenchSite)site).getSelectionProvider().getSelection()) instanceof TreeSelection) {
            TreeSelection ts = (TreeSelection)selection;
            if (ts.size() > 1) {
                return;
            }
            Object obj = ts.getFirstElement();
            if (obj instanceof PublishedModulesRoot) {
                this.showLibraryModulesAction = new ToogleSharedLibrariesAction((ISelection)selection);
                menu.add((IAction)this.showLibraryModulesAction);
                menu.add((IContributionItem)new Separator());
                this.showEarModulesAction = new ToogleEarModuleAction((ISelection)selection);
                menu.add((IAction)this.showEarModulesAction);
                this.showWebModulesAction = new ToogleWebModuleAction((ISelection)selection);
                menu.add((IAction)this.showWebModulesAction);
                this.showEjbModulesAction = new ToogleEjbModuleAction((ISelection)selection);
                menu.add((IAction)this.showEjbModulesAction);
                PublishedModulesRoot root = (PublishedModulesRoot)obj;
                this.showLibraryModulesAction.setChecked(root.isShowSharedLibraries());
                this.showEarModulesAction.setChecked(root.isShowEarModules());
                this.showWebModulesAction.setChecked(root.isShowWebModules());
                this.showEjbModulesAction.setChecked(root.isShowEjbModules());
            } else if (!(obj instanceof SharedLibraryRoot) && !(obj instanceof PublishedModuleTarget)) {
                PublishedModule m;
                if (obj instanceof WebServiceNode) {
                    LaunchWsdlAction action = new LaunchWsdlAction();
                    action.setSelection((ISelection)selection);
                    menu.add((IAction)action);
                } else if (obj instanceof PublishedModule && ((m = (PublishedModule)obj).getParent() instanceof PublishedModuleTarget || m.getParent() instanceof SharedLibraryRoot)) {
                    menu.add((IContributionItem)new Separator());
                    this.undeployAction.setSelection((ISelection)selection);
                    this.undeployAction.setEnabled(!m.isReadOnly());
                    menu.add((IAction)this.undeployAction);
                }
            }
        }
    }

    @Override
    protected void refresh(Object selection) {
        super.refresh(selection);
        if (selection instanceof PublishedModule) {
            PublishedModule root = (PublishedModule)selection;
            root.refresh();
        }
    }

    @Override
    protected String getExtensionId() {
        return DOMAIN_NAV_CONTENT_EXT_ID;
    }

    static class LaunchWsdlAction
    extends Action {
        ISelection selection;

        public LaunchWsdlAction() {
            this.setText(Resources.launchWsdl);
        }

        public void setSelection(ISelection selection) {
            this.selection = selection;
        }

        public void runWithEvent(Event event) {
            TreeSelection ts;
            Object obj;
            if (this.selection instanceof TreeSelection && (obj = (ts = (TreeSelection)this.selection).getFirstElement()) instanceof WebServiceNode) {
                try {
                    WebServiceNode wsNode = (WebServiceNode)obj;
                    String openURL = wsNode.getWsdlURI();
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser browser = browserSupport.createBrowser(6, null, null, null);
                    browser.openURL(new URL(openURL));
                }
                catch (Exception exception) {}
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String launchWsdl;
        public static String showLibaries;
        public static String showLibariesTooltip;
        public static String showEjbModules;
        public static String showEarModules;
        public static String showWebModules;
        public static String undeployModule;
        public static String undeployFailed;
        public static String moduleProperties;

        static {
            Resources.initializeMessages((String)PublishedModulesActionProvider.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    class ToogleEarModuleAction
    extends Action {
        ISelection selection;

        public ToogleEarModuleAction(ISelection selection) {
            this.setText(Resources.showEarModules);
            this.selection = selection;
        }

        public void runWithEvent(Event event) {
            TreeSelection ts;
            Object obj;
            if (this.selection instanceof TreeSelection && (obj = (ts = (TreeSelection)this.selection).getFirstElement()) instanceof PublishedModulesRoot) {
                PublishedModulesRoot root = (PublishedModulesRoot)obj;
                root.setShowEarModules(this.isChecked());
                StructuredViewer view = PublishedModulesActionProvider.this.getActionSite().getStructuredViewer();
                view.refresh(obj);
            }
            super.run();
        }

        public void run() {
            this.runWithEvent(null);
        }
    }

    class ToogleEjbModuleAction
    extends Action {
        ISelection selection;

        public ToogleEjbModuleAction(ISelection selection) {
            this.setText(Resources.showEjbModules);
            this.selection = selection;
        }

        public void runWithEvent(Event event) {
            TreeSelection ts;
            Object obj;
            if (this.selection instanceof TreeSelection && (obj = (ts = (TreeSelection)this.selection).getFirstElement()) instanceof PublishedModulesRoot) {
                PublishedModulesRoot root = (PublishedModulesRoot)obj;
                root.setShowEjbModules(this.isChecked());
                StructuredViewer view = PublishedModulesActionProvider.this.getActionSite().getStructuredViewer();
                view.refresh(obj);
            }
            super.run();
        }

        public void run() {
            this.runWithEvent(null);
        }
    }

    class ToogleSharedLibrariesAction
    extends Action {
        ISelection selection;

        public ToogleSharedLibrariesAction(ISelection selection) {
            this.setText(Resources.showLibaries);
            this.setToolTipText(Resources.showLibariesTooltip);
            this.selection = selection;
        }

        public void runWithEvent(Event event) {
            TreeSelection ts;
            Object obj;
            if (this.selection instanceof TreeSelection && (obj = (ts = (TreeSelection)this.selection).getFirstElement()) instanceof PublishedModulesRoot) {
                PublishedModulesRoot root = (PublishedModulesRoot)obj;
                root.setShowSharedLibraries(this.isChecked());
                StructuredViewer view = PublishedModulesActionProvider.this.getActionSite().getStructuredViewer();
                view.refresh(obj);
            }
            super.run();
        }

        public void run() {
            this.runWithEvent(null);
        }
    }

    class ToogleWebModuleAction
    extends Action {
        ISelection selection;

        public ToogleWebModuleAction(ISelection selection) {
            this.setText(Resources.showWebModules);
            this.selection = selection;
        }

        public void runWithEvent(Event event) {
            TreeSelection ts;
            Object obj;
            if (this.selection instanceof TreeSelection && (obj = (ts = (TreeSelection)this.selection).getFirstElement()) instanceof PublishedModulesRoot) {
                PublishedModulesRoot root = (PublishedModulesRoot)obj;
                root.setShowWebModules(this.isChecked());
                StructuredViewer view = PublishedModulesActionProvider.this.getActionSite().getStructuredViewer();
                view.refresh(obj);
            }
            super.run();
        }

        public void run() {
            this.runWithEvent(null);
        }
    }

    class UndeployModuleAction
    extends Action {
        ISelection selection;

        public UndeployModuleAction() {
            this.setText(Resources.undeployModule);
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        }

        public void setSelection(ISelection selection) {
            this.selection = selection;
        }

        public void runWithEvent(Event event) {
            if (this.selection instanceof TreeSelection) {
                TreeSelection ts = (TreeSelection)this.selection;
                if (!MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Undeploy Module", (String)"Are you sure you want to undeploy the selected module or library?")) {
                    return;
                }
                for (Object obj : ts) {
                    PublishedModuleTarget target;
                    if (!(obj instanceof PublishedModule)) continue;
                    PublishedModule module = (PublishedModule)obj;
                    PublishedModule parent = module.getParent();
                    if (parent instanceof PublishedModuleTarget) {
                        target = (PublishedModuleTarget)parent;
                        target.removeChildModule(module);
                    } else if (parent instanceof SharedLibraryRoot) {
                        target = (PublishedModuleTarget)module.getParent().getParent();
                        target.removeChildModule(module);
                    }
                    StructuredViewer view = PublishedModulesActionProvider.this.getActionSite().getStructuredViewer();
                    view.refresh((Object)module.getParent());
                }
            }
            super.run();
        }

        public void run() {
            this.runWithEvent(null);
        }
    }
}

