/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.server.internal.cnf.domainext;

import java.util.Set;
import oracle.eclipse.tools.weblogic.server.internal.util.DomainTemplateUtil;
import oracle.eclipse.tools.weblogic.server.operations.IExtendDomainOp;
import oracle.eclipse.tools.weblogic.ui.internal.WlsUiPlugin;
import oracle.eclipse.tools.weblogic.ui.server.internal.cnf.WeblogicCommonActionProvider;
import oracle.eclipse.tools.weblogic.ui.server.internal.cnf.domainext.DomainExtensionRoot;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphireWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.wst.server.core.IServer;

public class DomainExtensionsActionProvider
extends WeblogicCommonActionProvider {
    Action extendDomainAction;
    private static final String DOMAIN_NAV_CONTENT_EXT_ID = "oracle.eclipse.tools.weblogic.server.ui.ServersView.content.domainextensions";
    private static final String PREF_KEY_DONNOT_WARN_STOPSERVER = "PREF_KEY_DONNOT_WARN_STOPSERVER";

    @Override
    public void init(ICommonActionExtensionSite aSite) {
        StructuredViewer v;
        super.init(aSite);
        ICommonViewerSite site = aSite.getViewSite();
        if (site instanceof ICommonViewerWorkbenchSite && (v = aSite.getStructuredViewer()) instanceof CommonViewer) {
            CommonViewer cv = (CommonViewer)v;
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            this.makeActions(cv, wsSite.getSelectionProvider());
        }
    }

    private void makeActions(CommonViewer cv, ISelectionProvider selectionProvider) {
        ISelection sel = selectionProvider.getSelection();
        this.extendDomainAction = new ExtendDomainAction(sel);
    }

    @Override
    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
    }

    @Override
    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        ICommonViewerSite site = this.getActionSite().getViewSite();
        IStructuredSelection selection = null;
        if (site instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            selection = (IStructuredSelection)wsSite.getSelectionProvider().getSelection();
            this.extendDomainAction = new ExtendDomainAction((ISelection)selection);
            menu.add((IAction)this.extendDomainAction);
        }
    }

    @Override
    protected String getExtensionId() {
        return DOMAIN_NAV_CONTENT_EXT_ID;
    }

    class ExtendDomainAction
    extends Action {
        ISelection selection;

        public ExtendDomainAction(ISelection selection) {
            this.setText(Resources.extendDomain);
            this.setToolTipText(Resources.extendDomainTooltip);
            this.selection = selection;
        }

        public void runWithEvent(Event event) {
            TreeSelection ts;
            Object obj;
            if (this.selection instanceof TreeSelection && (obj = (ts = (TreeSelection)this.selection).getFirstElement()) instanceof DomainExtensionRoot) {
                boolean donNotDisplayMessage;
                IServer server = ((DomainExtensionRoot)obj).getServer();
                Set ret = DomainTemplateUtil.getAvailableExtensionTemplates((IServer)server);
                if (ret.size() == 0) {
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Resources.warning, (String)Resources.noExtensionTemplate);
                    this.setEnabled(false);
                    return;
                }
                final boolean[] isCanceled = new boolean[1];
                if (server.getServerState() != 4 && !(donNotDisplayMessage = WlsUiPlugin.getInstance().getPreferenceStore().getBoolean(DomainExtensionsActionProvider.PREF_KEY_DONNOT_WARN_STOPSERVER))) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialogWithToggle toggle = MessageDialogWithToggle.openOkCancelConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Resources.warning, (String)Resources.serverWillBeStopped, (String)Resources.dontDisplayWarning, (boolean)false, (IPreferenceStore)WlsUiPlugin.getInstance().getPreferenceStore(), (String)DomainExtensionsActionProvider.PREF_KEY_DONNOT_WARN_STOPSERVER);
                            boolean val = toggle.getToggleState();
                            int n = toggle.getReturnCode();
                            isCanceled[0] = n == 1;
                            WlsUiPlugin.getInstance().getPreferenceStore().setValue(DomainExtensionsActionProvider.PREF_KEY_DONNOT_WARN_STOPSERVER, val);
                        }
                    });
                }
                if (isCanceled[0]) {
                    return;
                }
                IExtendDomainOp op = (IExtendDomainOp)IExtendDomainOp.TYPE.instantiate();
                op.setServerid(server.getId());
                SapphireWizard wizard = new SapphireWizard((Element)op, DefinitionLoader.context(((Object)((Object)this)).getClass()).sdef("ExtendDomainWizard").wizard());
                WizardDialog dlg = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
                if (dlg.open() == 0) {
                    StructuredViewer view = DomainExtensionsActionProvider.this.getActionSite().getStructuredViewer();
                    view.refresh(obj);
                }
                op.dispose();
            }
            super.run();
        }

        public void run() {
            this.runWithEvent(null);
        }
    }

    private static final class Resources
    extends NLS {
        public static String dontDisplayWarning;
        public static String serverWillBeStopped;
        public static String warning;
        public static String extendDomain;
        public static String extendDomainTooltip;
        public static String noExtensionTemplate;

        static {
            Resources.initializeMessages((String)DomainExtensionsActionProvider.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

