/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.server.internal.actions;

import oracle.eclipse.tools.weblogic.server.IJ2EEDeploymentHelper;
import oracle.eclipse.tools.weblogic.server.ServerInfo;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerBehaviour;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.wst.server.core.IServer;

public abstract class ServerActionBase
implements IViewActionDelegate {
    private static final String PROP_IS_WEBLOGIC_SERVER = "oracle.eclipse.tools.weblogic.ui.isWebLogicServer";
    ISelection selection;
    WeblogicServer weblogic;

    public void runWithEvent(Event event) {
        this.run(null);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        if (this.selection instanceof TreeSelection) {
            TreeSelection ts = (TreeSelection)this.selection;
            Object obj = ts.getFirstElement();
            if (obj instanceof IServer) {
                IServer server = (IServer)obj;
                this.weblogic = (WeblogicServer)server.getAdapter(WeblogicServer.class);
            }
            action.setEnabled(this.weblogic != null);
        }
        System.setProperty(PROP_IS_WEBLOGIC_SERVER, Boolean.toString(this.weblogic != null));
    }

    protected String getDomainName() {
        ServerInfo info;
        if (this.weblogic == null) {
            return null;
        }
        if (this.weblogic.isRemote()) {
            WeblogicServerBehaviour behavior = (WeblogicServerBehaviour)this.weblogic.getServer().loadAdapter(WeblogicServerBehaviour.class, null);
            if (behavior == null) {
                return null;
            }
            IJ2EEDeploymentHelper helper = behavior.getPublisher();
            if (helper == null) {
                return null;
            }
            try {
                return helper.getDomainName();
            }
            catch (CoreException coreException) {}
        }
        if ((info = this.weblogic.getServerInfo()) == null) {
            return null;
        }
        return info.getDomainName();
    }

    public void init(IViewPart arg0) {
    }
}

