/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.server.internal.actions;

import java.net.MalformedURLException;
import java.net.URL;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.server.ServerInfo;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import oracle.eclipse.tools.weblogic.ui.server.internal.Resources;
import oracle.eclipse.tools.weblogic.ui.server.internal.actions.ServerActionBase;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;
import org.eclipse.wst.server.core.IRuntime;

public class OpenOnlineDocAction
extends ServerActionBase {
    public void run(IAction action) {
        IWorkbenchBrowserSupport support = WorkbenchBrowserSupport.getInstance();
        try {
            String pageName = String.valueOf(Resources.getString("editorPage.onlineDocBbrowserTitle", new Object[0])) + " [" + this.weblogic.getServer().getRuntime().getName() + "]";
            IWebBrowser browser = support.createBrowser(6, "wl-doc-browser-id" + this.weblogic.getServer().getId(), pageName, null);
            browser.openURL(this.getOnlineDocURL());
        }
        catch (PartInitException pie) {
            String msgError = Resources.getString("error", new Object[0]);
            String msgFailed = Resources.getString("editorPage.errorOpenBrowser", new Object[0]);
            ErrorDialog dialog = new ErrorDialog(Display.getDefault().getActiveShell(), msgError, msgFailed, pie.getStatus(), 6);
            dialog.open();
        }
    }

    private URL getOnlineDocURL() {
        WeblogicServer weblogic = this.weblogic;
        if (weblogic == null) {
            return null;
        }
        ServerInfo info = weblogic.getServerInfo();
        if (info == null) {
            return null;
        }
        IRuntime rt = weblogic.getServer().getRuntime();
        WebLogicServerVersion version = WebLogicServerVersion.detect((IRuntime)rt);
        String docUrl = "http://www.oracle.com/technetwork/middleware/weblogic/documentation/index.html";
        if (version.compareTo((Enum)WebLogicServerVersion.VERSION_10_3_0) < 0) {
            StringBuilder sb = new StringBuilder();
            char[] cArray = version.getVersionString().toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (c != '.') {
                    sb.append(c);
                }
                ++n2;
            }
            docUrl = "http://download.oracle.com/wls/docs" + sb.toString() + "/";
        }
        try {
            return new URL(docUrl);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setActionDefinitionId("oracle.eclipse.tools.weblogic.ui.server.internal.action.openOnlineDoc");
    }
}

