/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.server.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerInstall;
import oracle.eclipse.tools.weblogic.ui.AsyncInstallCallback;
import oracle.eclipse.tools.weblogic.ui.WebLogicServerComponentHandler;
import oracle.eclipse.tools.weblogic.ui.internal.WebLogicServerComponentHandlersExtPoint;
import oracle.eclipse.tools.weblogic.ui.internal.WlsUiPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public final class WebLogicServerExtensionsControl
extends Composite {
    private IRuntime runtime;
    private Image checkmarkImage;
    private Image checkmarkOffImage;
    private Composite extensionsComposite;

    public WebLogicServerExtensionsControl(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)SwtUtil.glayout((int)1, (int)0, (int)0));
        Label label = new Label((Composite)this, 0);
        label.setText(Resources.extensionsLabel);
        label.setLayoutData((Object)SwtUtil.gdvindent((GridData)SwtUtil.gd(), (int)15));
        Label separator = new Label((Composite)this, 258);
        separator.setLayoutData((Object)SwtUtil.gdhfill());
        this.extensionsComposite = new Composite((Composite)this, 0);
        this.extensionsComposite.setLayoutData((Object)SwtUtil.gdhfill());
        this.extensionsComposite.setLayout((Layout)SwtUtil.glspacing((GridLayout)SwtUtil.glayout((int)3, (int)0, (int)0), (int)2, (int)5));
        this.checkmarkImage = org.eclipse.sapphire.ui.forms.swt.SwtUtil.createImageDescriptor(WlsUiPlugin.class, (String)"images/checkmark.png").createImage();
        this.checkmarkOffImage = org.eclipse.sapphire.ui.forms.swt.SwtUtil.createImageDescriptor(WlsUiPlugin.class, (String)"images/checkmark-off.png").createImage();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                WebLogicServerExtensionsControl.this.checkmarkImage.dispose();
                WebLogicServerExtensionsControl.this.checkmarkOffImage.dispose();
            }
        });
    }

    public void setRuntime(IRuntime runtime) {
        this.runtime = runtime;
    }

    public void clean() {
        Control[] controlArray = this.extensionsComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
    }

    public void update() {
        Control[] controlArray = this.extensionsComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        boolean extensions = false;
        if (this.runtime != null) {
            final WebLogicServerInstall install = WebLogicServerInstall.getWebLogicServerInstall((IRuntime)this.runtime);
            ArrayList<WebLogicServerComponentHandler> handlers = new ArrayList<WebLogicServerComponentHandler>();
            if (install != null && install.isValid()) {
                for (final WebLogicServerComponentHandler handler : WebLogicServerComponentHandlersExtPoint.getHandlers()) {
                    if (!handler.applicable(install)) continue;
                    handlers.add(handler);
                }
            }
            if (!handlers.isEmpty()) {
                for (final WebLogicServerComponentHandler handler : handlers) {
                    Link action;
                    Label checkmark = new Label(this.extensionsComposite, 0);
                    checkmark.setLayoutData((Object)SwtUtil.gd());
                    Label extensionNameLabel = new Label(this.extensionsComposite, 0);
                    extensionNameLabel.setText(handler.getName(install));
                    extensionNameLabel.setLayoutData((Object)SwtUtil.gd());
                    if (handler.installed(install)) {
                        checkmark.setImage(this.checkmarkImage);
                        checkmark.setToolTipText(Resources.installedToolTip);
                        action = new Link(this.extensionsComposite, 0);
                        action.setText("<A>" + Resources.uninstallActionLabel + "</A>");
                        action.setLayoutData((Object)SwtUtil.gdhindent((GridData)SwtUtil.gd(), (int)15));
                        if (handler.uninstallable(install)) {
                            action.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent event) {
                                    try {
                                        if (!WebLogicServerExtensionsControl.this.checkRunningServers()) {
                                            return;
                                        }
                                        handler.uninstall(install, action.getShell());
                                    }
                                    catch (Exception e) {
                                        WlsUiPlugin.log(e);
                                    }
                                    WebLogicServerExtensionsControl.this.update();
                                }
                            });
                            continue;
                        }
                        action.setVisible(false);
                        continue;
                    }
                    checkmark.setImage(this.checkmarkOffImage);
                    checkmark.setToolTipText(Resources.notInstalledToolTip);
                    if (!handler.installable(install)) {
                        checkmark.setVisible(false);
                        extensionNameLabel.setVisible(false);
                        Label label = new Label(this.extensionsComposite, 0);
                        label.setLayoutData((Object)SwtUtil.gdhindent((GridData)SwtUtil.gd(), (int)15));
                        continue;
                    }
                    checkmark.setVisible(true);
                    extensionNameLabel.setVisible(true);
                    action = new Link(this.extensionsComposite, 0);
                    action.setText("<A>" + Resources.installActionLabel + "</A>");
                    action.setLayoutData((Object)SwtUtil.gdhindent((GridData)SwtUtil.gd(), (int)15));
                    action.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            try {
                                if (!WebLogicServerExtensionsControl.this.checkRunningServers()) {
                                    return;
                                }
                                handler.install(install, action.getShell(), new AsyncInstallCallback(){

                                    @Override
                                    public void done() {
                                        Display.getDefault().asyncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                if (!WebLogicServerExtensionsControl.this.extensionsComposite.isDisposed()) {
                                                    WebLogicServerExtensionsControl.this.update();
                                                }
                                            }
                                        });
                                    }
                                });
                            }
                            catch (Exception e) {
                                WlsUiPlugin.log(e);
                            }
                            WebLogicServerExtensionsControl.this.update();
                        }
                    });
                }
                extensions = true;
            }
        }
        if (!extensions) {
            Label label = new Label(this.extensionsComposite, 0);
            label.setText(Resources.noApplicableExtensions);
            label.setLayoutData((Object)SwtUtil.hspan((GridData)SwtUtil.gd(), (int)3));
        }
        this.layout(true, true);
    }

    protected boolean checkRunningServers() throws InterruptedException {
        final ArrayList<IServer> runningServers = new ArrayList<IServer>();
        IServer[] iServerArray = ServerCore.getServers();
        int n = iServerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            if (server.getRuntime().getId().equals(this.runtime.getId()) && (server.getServerState() == 2 || server.getServerState() == 1)) {
                runningServers.add(server);
            }
            ++n2;
        }
        if (runningServers.size() > 0) {
            boolean ret = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)Resources.warnRunningServerDlgTitle, (String)Resources.warnRunningServerMessage);
            if (!ret) {
                return false;
            }
            final boolean[] isServerStopped = new boolean[1];
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask("Stopping WebLogic server", 100 * runningServers.size());
                    for (IServer server : runningServers) {
                        server.stop(false, new IServer.IOperationListener(){

                            public void done(IStatus result) {
                                isServerStopped[0] = true;
                            }
                        });
                        monitor.worked(10);
                    }
                    monitor.worked(50);
                    while (!isServerStopped[0]) {
                        Display.getDefault().readAndDispatch();
                    }
                }
            };
            try {
                new ProgressMonitorDialog(Display.getDefault().getActiveShell()).run(false, false, op);
            }
            catch (InvocationTargetException invocationTargetException) {}
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(true);
            PlatformUI.getWorkbench().restart();
        }
        return true;
    }

    private static final class Resources
    extends NLS {
        public static String extensionsLabel;
        public static String noApplicableExtensions;
        public static String installActionLabel;
        public static String uninstallActionLabel;
        public static String installedToolTip;
        public static String notInstalledToolTip;
        public static String warnRunningServerDlgTitle;
        public static String warnRunningServerMessage;

        static {
            Resources.initializeMessages((String)WebLogicServerExtensionsControl.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

