/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.server.internal;

import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.server.internal.util.DomainTemplateUtil;
import oracle.eclipse.tools.weblogic.server.internal.util.TemplateInfo;
import oracle.eclipse.tools.weblogic.server.operations.ICreateDefaultDomainOp;
import oracle.eclipse.tools.weblogic.server.operations.IExtendDomainOp;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.swt.CheckBoxListPropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class TemplateDescriptionElementFactory
extends FormComponentPart {
    public FormComponentPresentation createPresentation(SwtPresentation parent, Composite composite) {
        return new FormComponentPresentation(this, parent, composite){
            Text description;
            {
                this.description = null;
            }

            public void render() {
                Composite parent = this.composite();
                Label label = new Label(parent, 0);
                label.setText("&Description");
                GridData gd = SwtUtil.gd();
                gd.horizontalSpan = 2;
                gd.horizontalIndent = 9;
                label.setLayoutData((Object)SwtUtil.valign((GridData)gd, (int)128));
                this.description = new Text(parent, 2122);
                this.description.setText("\n\n\n");
                gd = GridLayoutUtil.gdhfill();
                gd.horizontalSpan = 2;
                gd.horizontalIndent = 9;
                gd.heightHint = 50;
                this.description.setLayoutData((Object)SwtUtil.valign((GridData)gd, (int)128));
                Table table = this.findTableControl(parent.getParent());
                table.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        Table t = (Table)e.getSource();
                        TableItem[] selection = t.getSelection();
                        if (selection.length == 0) {
                            return;
                        }
                        Object o = selection[0].getData();
                        if (o instanceof CheckBoxListPropertyEditorPresentation.Entry) {
                            CheckBoxListPropertyEditorPresentation.Entry elm = (CheckBoxListPropertyEditorPresentation.Entry)o;
                            String text = elm.label();
                            String descText = this.getTemplateDescription(text);
                            description.setText(descText == null ? "" : descText);
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }

            private String getTemplateDescription(String name) {
                TemplateInfo info;
                Element model = this.part().getModelElement();
                String runtimeId = null;
                if (model instanceof IExtendDomainOp) {
                    IExtendDomainOp op = (IExtendDomainOp)TemplateDescriptionElementFactory.this.getModelElement();
                    String serverId = (String)op.getServerid().content();
                    IServer server = ServerCore.findServer((String)serverId);
                    if (server != null) {
                        runtimeId = server.getRuntime().getId();
                    }
                } else {
                    ICreateDefaultDomainOp operation = (ICreateDefaultDomainOp)model.nearest(ICreateDefaultDomainOp.class);
                    if (operation != null) {
                        runtimeId = (String)operation.getRuntimeid().content();
                    }
                }
                if (runtimeId != null && (info = (TemplateInfo)DomainTemplateUtil.findAllDomainExtensionTemplates((IRuntime)WlsRuntimeUtil.getRuntime(runtimeId)).get(name)) != null) {
                    return info.description;
                }
                return null;
            }

            private Table findTableControl(Composite parent) {
                Control[] controlArray = parent.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Table t;
                    Control c = controlArray[n2];
                    if (c instanceof Table) {
                        t = (Table)c;
                        return t;
                    }
                    if (c instanceof Composite && (t = this.findTableControl((Composite)c)) != null) {
                        return t;
                    }
                    ++n2;
                }
                return null;
            }
        };
    }
}

