/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.migration.internal;

import java.util.Set;
import oracle.eclipse.tools.common.ui.systemresources.FontKey;
import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.common.ui.widgets.ProjectsDisplayPanel;
import oracle.eclipse.tools.weblogic.ui.migration.internal.RuntimeMigrationResources;
import oracle.eclipse.tools.weblogic.ui.migration.internal.RuntimeMigrationServerPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;

public class RuntimeMigrationMainPage
extends WizardPage
implements IDataModelListener {
    private IDataModel model;

    public RuntimeMigrationMainPage(IWorkbench workbench, IStructuredSelection selection, IDataModel model) {
        super("runtime-migration-main-page");
        IProject[] allProjects;
        model.addListener((IDataModelListener)this);
        this.setPageComplete(false);
        this.setTitle(RuntimeMigrationResources.SelectProjects);
        this.setMessage(RuntimeMigrationResources.AllProjects);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = allProjects = workspace.getRoot().getProjects();
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (!project.isOpen()) {
                this.setMessage(RuntimeMigrationResources.ClosedProjects, 2);
                break;
            }
            ++n2;
        }
        this.model = model;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        this.createPageContent(composite);
        this.setControl((Control)composite);
    }

    private void createPageContent(Composite parent) {
        this.addProjectsPanel(parent);
        this.addNote(parent);
        this.addServerPanel(parent);
    }

    private void addProjectsPanel(Composite parent) {
        Label projectsLabel = new Label(parent, 0);
        projectsLabel.setText(RuntimeMigrationResources.ProjectsLabel);
        ProjectsDisplayPanel projectsPanel = new ProjectsDisplayPanel(parent, 0);
        projectsPanel.setLayout((Layout)new GridLayout(1, false));
        projectsPanel.setLayoutData((Object)new GridData(1808));
        projectsPanel.setBackground(Display.getDefault().getSystemColor(22));
        projectsPanel.setProjects((Set)this.model.getProperty("IRuntimeMigrationDataModelProperties.PROJECTS"));
    }

    private void addServerPanel(Composite parent) {
        Group serverInfo = new Group(parent, 0);
        serverInfo.setLayout((Layout)new GridLayout(1, false));
        serverInfo.setLayoutData((Object)new GridData(768));
        serverInfo.setText(RuntimeMigrationResources.targetRuntimeSection);
        new RuntimeMigrationServerPage((Composite)serverInfo, 0, this.model);
    }

    private void addNote(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)SwtUtil.gdhfill());
        composite.setLayout((Layout)new GridLayout(2, false));
        Label noticeLabel = new Label(composite, 0);
        FontData labelFontData = new FontData("Arial", 10, 1);
        noticeLabel.setFont(new FontKey(labelFontData).getFont());
        noticeLabel.setText(Resources.noteLabel);
        noticeLabel.setLayoutData((Object)new GridData(2));
        Label noticeText = new Label(composite, 64);
        noticeText.setLayoutData((Object)SwtUtil.gdwhint((GridData)SwtUtil.gdhfill(), (int)300));
        noticeText.setText(Resources.noteText);
    }

    public void propertyChanged(DataModelEvent event) {
        this.setPageComplete(event.getDataModel().isPropertySet("IRuntimeMigrationDataModelProperties.SELECTED_RUNTIME"));
    }

    private static final class Resources
    extends NLS {
        public static String noteLabel;
        public static String noteText;

        static {
            Resources.initializeMessages((String)RuntimeMigrationMainPage.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

