/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.migration.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import oracle.eclipse.tools.weblogic.ui.migration.internal.RuntimeMigrationResources;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class RuntimeMigrationErrorDialog
extends IconAndMessageDialog {
    private static final int LIST_ITEM_COUNT = 15;
    private Button detailsButton;
    private String title;
    private IStatus status;
    private Composite detailsArea;
    private boolean detailsCreated = false;

    public RuntimeMigrationErrorDialog(Shell parent, IStatus status) {
        super(parent);
        if (status.getSeverity() == 2) {
            this.title = RuntimeMigrationResources.MigrationWarningTitle;
            this.message = RuntimeMigrationResources.MigrationWarningMessage;
        } else {
            this.title = RuntimeMigrationResources.MigrationErrorTitle;
            this.message = RuntimeMigrationResources.MigrationErrorMessage;
        }
        this.status = status;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        this.createMessageArea(parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData childData = new GridData(1808);
        childData.horizontalSpan = 2;
        composite.setLayoutData((Object)childData);
        composite.setFont(parent.getFont());
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 2, IDialogConstants.OK_LABEL, true);
        this.detailsButton = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 13) {
            this.toggleDetailsArea();
        }
        if (buttonId == 2) {
            this.setReturnCode(2);
            this.close();
        }
        if (buttonId == 3) {
            this.setReturnCode(3);
            this.close();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected Image getImage() {
        if (this.status != null) {
            if (this.status.getSeverity() == 2) {
                return this.getWarningImage();
            }
            if (this.status.getSeverity() == 1) {
                return this.getInfoImage();
            }
        }
        return this.getErrorImage();
    }

    private void toggleDetailsArea() {
        Point windowSize = this.getShell().getSize();
        Point oldSize = this.getShell().computeSize(-1, -1);
        if (this.detailsCreated) {
            this.detailsArea.dispose();
            this.detailsCreated = false;
            this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        } else {
            this.detailsArea = this.createDetailsArea((Composite)this.getContents());
            this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
        }
        Point newSize = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, windowSize.y + (newSize.y - oldSize.y)));
    }

    private Composite createDetailsArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData childData = new GridData(1808);
        childData.horizontalSpan = 2;
        composite.setLayoutData((Object)childData);
        composite.setFont(parent.getFont());
        Label textLabel = new Label(composite, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        textLabel.setLayoutData((Object)gd);
        Text details = new Text(composite, 2818);
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = details.getLineHeight() * 15;
        gd.horizontalSpan = 2;
        details.setLayoutData((Object)gd);
        details.setEditable(false);
        details.setText(this.getErrorDetails());
        this.detailsCreated = true;
        return composite;
    }

    private String getErrorDetails() {
        if (this.status != null) {
            StringBuffer sb = new StringBuffer();
            this.appendErrorText(this.status, sb);
            return sb.toString();
        }
        return null;
    }

    private void appendErrorText(IStatus status, StringBuffer sb) {
        String errorLabel = RuntimeMigrationResources.StatusError;
        String warningLabel = RuntimeMigrationResources.StatusWarning;
        if (status != null) {
            if (status.isMultiStatus()) {
                IStatus[] iStatusArray = status.getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus child = iStatusArray[n2];
                    this.appendErrorText(child, sb);
                    ++n2;
                }
            } else {
                sb.append(status.getSeverity() == 2 ? warningLabel : errorLabel);
                sb.append(": ");
                sb.append(status.getMessage());
                sb.append('\n');
                if (status.getException() != null) {
                    sb.append(this.getStackTrace(status));
                    sb.append('\n');
                }
                sb.append('\n');
            }
        }
    }

    private String getStackTrace(IStatus status) {
        Throwable exception = status.getException();
        if (exception != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            exception.printStackTrace(pw);
            return sw.toString();
        }
        return null;
    }
}

