/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.j2eelib.provider.internal;

import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.common.ui.widgets.EnhancedComposite;
import oracle.eclipse.tools.common.ui.widgets.EnhancedHyperlink;
import oracle.eclipse.tools.weblogic.j2eelib.Version;
import oracle.eclipse.tools.weblogic.j2eelib.provider.SharedLibraryProviderInstallOperationConfig;
import oracle.eclipse.tools.weblogic.ui.internal.WlsUiPlugin;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jst.common.project.facet.core.libprov.IPropertyChangeListener;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperationConfig;
import org.eclipse.jst.common.project.facet.ui.libprov.LibraryProviderOperationPanel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;

public class SharedLibraryProviderInstallOperationPanel
extends LibraryProviderOperationPanel {
    private static final int MINIMUM_TEXT_FIELD_WIDTH = 100;
    protected SharedLibraryProviderInstallOperationConfig config = null;
    protected Composite composite = null;
    private Text libraryNameTextField = null;
    private Text libraryVersionTextField = null;
    private Label allowNewerImage = null;

    public void setOperationConfig(LibraryProviderOperationConfig config) {
        super.setOperationConfig(config);
        this.config = (SharedLibraryProviderInstallOperationConfig)config;
    }

    public Control createControl(Composite parent) {
        this.composite = new EnhancedComposite(parent, 0);
        this.composite.setLayout((Layout)SwtUtil.glayout((int)2, (int)0, (int)0));
        ModifyListener textContentsChangedListener = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                SharedLibraryProviderInstallOperationPanel.this.resetTextFieldWidths();
            }
        };
        Label libraryNameLabel = new Label(this.composite, 0);
        libraryNameLabel.setText(Resources.libraryNameLabel);
        this.libraryNameTextField = new Text(this.composite, 2056);
        SharedLibraryProviderInstallOperationPanel.bindLibraryNameTextToModel(this.libraryNameTextField, this.config);
        this.libraryNameTextField.addModifyListener(textContentsChangedListener);
        Label libraryVersionLabel = new Label(this.composite, 0);
        libraryVersionLabel.setText(Resources.libraryVersionLabel);
        EnhancedComposite libraryVersionComposite = new EnhancedComposite(this.composite, 0);
        libraryVersionComposite.setLayout((Layout)SwtUtil.glayout((int)2, (int)0, (int)0));
        this.libraryVersionTextField = new Text((Composite)libraryVersionComposite, 2056);
        this.libraryVersionTextField.addModifyListener(textContentsChangedListener);
        SharedLibraryProviderInstallOperationPanel.bindLibraryVersionTextToModel(this.libraryVersionTextField, this.config);
        this.allowNewerImage = new Label((Composite)libraryVersionComposite, 0);
        SharedLibraryProviderInstallOperationPanel.bindAllowNewerImageToModel(this.allowNewerImage, this.config);
        EnhancedHyperlink manageLibrariesLink = new EnhancedHyperlink(this.composite, 0);
        manageLibrariesLink.setLayoutData((Object)SwtUtil.hspan((GridData)SwtUtil.gd(), (int)2));
        manageLibrariesLink.setText(Resources.manageJ2EELibrariesLink);
        manageLibrariesLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent evt) {
                SharedLibraryProviderInstallOperationPanel.this.handleManageLibrariesLinkActivated();
            }
        });
        this.resetTextFieldWidths();
        return this.composite;
    }

    protected void handleManageLibrariesLinkActivated() {
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.composite.getShell(), (String)"oracle.eclipse.tools.weblogic.ui.j2eelib.LibraryModulesPreferencePage", (String[])new String[]{"oracle.eclipse.tools.weblogic.ui.j2eelib.LibraryModulesPreferencePage"}, null);
        dialog.open();
    }

    private static void bindLibraryNameTextToModel(final Text libraryNameTextField, final SharedLibraryProviderInstallOperationConfig config) {
        final IPropertyChangeListener modelListener = new IPropertyChangeListener(){

            public void propertyChanged(String prop, Object oldValue, Object newValue) {
                SharedLibraryProviderInstallOperationPanel.setLibraryNameText(libraryNameTextField, config);
            }
        };
        config.addListener(modelListener, new String[]{SharedLibraryProviderInstallOperationConfig.PROP_LIBRARY_NAME});
        SharedLibraryProviderInstallOperationPanel.setLibraryNameText(libraryNameTextField, config);
        libraryNameTextField.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                config.removeListener(modelListener);
            }
        });
    }

    private static void bindLibraryVersionTextToModel(final Text libraryVersionTextField, final SharedLibraryProviderInstallOperationConfig config) {
        final IPropertyChangeListener modelListener = new IPropertyChangeListener(){

            public void propertyChanged(String prop, Object oldValue, Object newValue) {
                SharedLibraryProviderInstallOperationPanel.setLibraryVersionText(libraryVersionTextField, config);
            }
        };
        config.addListener(modelListener, new String[]{SharedLibraryProviderInstallOperationConfig.PROP_SPECIFICATION_VERSION, SharedLibraryProviderInstallOperationConfig.PROP_IMPLEMENTATION_VERSION});
        SharedLibraryProviderInstallOperationPanel.setLibraryVersionText(libraryVersionTextField, config);
        libraryVersionTextField.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                config.removeListener(modelListener);
            }
        });
    }

    private static void setLibraryNameText(Text libraryNameTextField, SharedLibraryProviderInstallOperationConfig config) {
        String libraryName = config.getLibraryName();
        libraryNameTextField.setText(libraryName == null ? "" : libraryName);
    }

    private static void setLibraryVersionText(Text libraryVersionTextField, SharedLibraryProviderInstallOperationConfig config) {
        StringBuilder text = new StringBuilder();
        Version specVersion = config.getSpecificationVersion();
        Version implVersion = config.getImplementationVersion();
        if (specVersion != null) {
            text.append(specVersion.toString());
        }
        if (implVersion != null) {
            text.append(" / ");
            text.append(implVersion.toString());
        }
        libraryVersionTextField.setText(text.toString());
    }

    private static void bindAllowNewerImageToModel(final Label allowNewerImage, final SharedLibraryProviderInstallOperationConfig config) {
        final IPropertyChangeListener modelListener = new IPropertyChangeListener(){

            public void propertyChanged(String prop, Object oldValue, Object newValue) {
                SharedLibraryProviderInstallOperationPanel.setAllowNewerImage(allowNewerImage, config);
            }
        };
        config.addListener(modelListener, new String[]{SharedLibraryProviderInstallOperationConfig.PROP_ALLOW_NEWER_VERSIONS});
        SharedLibraryProviderInstallOperationPanel.setAllowNewerImage(allowNewerImage, config);
        allowNewerImage.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                config.removeListener(modelListener);
            }
        });
    }

    private static void setAllowNewerImage(Label allowNewerImage, SharedLibraryProviderInstallOperationConfig config) {
        boolean allowNewer = config.getAllowNewerVersions();
        String imageId = allowNewer ? "j2eelib.newer.versions.ok" : "j2eelib.newer.versions.not.ok";
        allowNewerImage.setImage(WlsUiPlugin.getInstance().getImageRegistry().get(imageId));
        String tooltip = allowNewer ? Resources.newerVersionsAllowedToolTip : Resources.newerVersionsNotAllowedToolTip;
        allowNewerImage.setToolTipText(tooltip);
    }

    private void resetTextFieldWidths() {
        int a = this.libraryNameTextField.computeSize((int)-1, (int)-1).x;
        int b = this.libraryVersionTextField.computeSize((int)-1, (int)-1).x;
        int width = Math.max(Math.max(a, b), 100);
        this.libraryNameTextField.setLayoutData((Object)SwtUtil.gdwhint((GridData)SwtUtil.gd(), (int)width));
        this.libraryVersionTextField.setLayoutData((Object)SwtUtil.gdwhint((GridData)SwtUtil.gd(), (int)width));
        this.composite.layout(true, true);
    }

    private static final class Resources
    extends NLS {
        public static String libraryNameLabel;
        public static String libraryVersionLabel;
        public static String manageJ2EELibrariesLink;
        public static String newerVersionsAllowedToolTip;
        public static String newerVersionsNotAllowedToolTip;

        static {
            Resources.initializeMessages((String)SharedLibraryProviderInstallOperationPanel.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

