/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.j2eelib.internal.resolutions;

import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRef;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModulesSvc;
import oracle.eclipse.tools.weblogic.ui.j2eelib.SharedLibrariesFrameworkUi;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.EditFailedException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;

public final class ModifyLibraryRefInDescriptorResolution
implements IMarkerResolution {
    private final Shell shell;
    private final IProject project;
    private final LibraryModuleRef libraryReference;

    public ModifyLibraryRefInDescriptorResolution(Shell shell, IProject project, LibraryModuleRef libraryReference) {
        this.shell = shell;
        this.project = project;
        this.libraryReference = libraryReference;
    }

    public String getLabel() {
        if (WtpProjectUtil.isDynamicWebProject((IProject)this.project)) {
            return Resources.bind((String)Resources.labelForWeb, (Object)this.libraryReference.getName());
        }
        return Resources.bind((String)Resources.labelForEar, (Object)this.libraryReference.getName());
    }

    public void run(IMarker marker) {
        LibraryModuleRef newLibraryReference = SharedLibrariesFrameworkUi.showEditLibraryRefDialog(this.shell, this.libraryReference, WtpProjectUtil.isDynamicWebProject((IProject)this.project));
        if (newLibraryReference != null && !newLibraryReference.equals((Object)this.libraryReference)) {
            try {
                LibraryModulesSvc.updateInDescriptor((IProject)this.project, (String)this.libraryReference.getName(), (LibraryModuleRef)newLibraryReference);
            }
            catch (EditFailedException editFailedException) {
            }
            catch (CoreException e) {
                DialogService.showErrorDialog((Throwable)e);
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String labelForWeb;
        public static String labelForEar;

        static {
            Resources.initializeMessages((String)ModifyLibraryRefInDescriptorResolution.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

