/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.j2eelib.internal.resolutions;

import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRef;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModulesSvc;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;

public final class ModifyClasspathToMatchResolution
implements IMarkerResolution {
    private final IProject project;
    private final IProject descriptorProject;
    private final LibraryModuleRef libraryReference;

    public ModifyClasspathToMatchResolution(Shell shell, IProject project, IProject descriptorProject, LibraryModuleRef libraryReference) {
        this.project = project;
        this.descriptorProject = descriptorProject;
        this.libraryReference = libraryReference;
    }

    public String getLabel() {
        if (WtpProjectUtil.isDynamicWebProject((IProject)this.descriptorProject)) {
            return Resources.labelForWeb;
        }
        return Resources.bind((String)Resources.labelForEar, (Object)this.descriptorProject.getName());
    }

    public void run(IMarker marker) {
        try {
            LibraryModulesSvc.updateInClasspath((IProject)this.project, (String)this.libraryReference.getName(), (LibraryModuleRef)this.libraryReference);
        }
        catch (CoreException e) {
            DialogService.showErrorDialog((Throwable)e);
        }
    }

    private static final class Resources
    extends NLS {
        public static String labelForWeb;
        public static String labelForEar;

        static {
            Resources.initializeMessages((String)ModifyClasspathToMatchResolution.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

