/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.j2eelib.internal;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.common.util.IListener;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModule;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRef;
import oracle.eclipse.tools.weblogic.j2eelib.Version;
import oracle.eclipse.tools.weblogic.ui.internal.WlsUiPlugin;
import oracle.eclipse.tools.weblogic.ui.j2eelib.BrowseLibraryModulesDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class LibraryModuleRefPanel
extends Composite {
    private boolean webOnly;
    private Label nameLabel;
    private Text nameTextField;
    private Text specVersionTextField;
    private Label specVersionLabel;
    private Text implVersionTextField;
    private Label implVersionLabel;
    private Button browseButton;
    private Button newerVersionCheckBox;
    private ModifyListener modifyListener;
    private List<IListener> listeners;

    public LibraryModuleRefPanel(Composite parent, int style, boolean webOnly) {
        super(parent, style);
        this.webOnly = webOnly;
        this.listeners = new CopyOnWriteArrayList<IListener>();
        this.setLayout((Layout)new GridLayout(2, false));
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                LibraryModuleRefPanel.this.refresh();
                LibraryModuleRefPanel.this.notifyListeners();
            }
        };
        this.nameLabel = new Label((Composite)this, 0);
        this.nameLabel.setText(Resources.nameLabel);
        this.nameLabel.setLayoutData((Object)SwtUtil.hspan((GridData)SwtUtil.gdhfill(), (int)2));
        this.nameTextField = new Text((Composite)this, 2048);
        this.nameTextField.setLayoutData((Object)SwtUtil.gdhfill());
        this.nameTextField.addModifyListener(this.modifyListener);
        this.nameTextField.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent evt) {
                LibraryModuleRefPanel.this.verifyNameText(evt);
            }
        });
        this.browseButton = new Button((Composite)this, 8);
        this.browseButton.setText(Resources.browseButtonLabel);
        SelectionAdapter browseListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LibraryModuleRefPanel.this.performBrowse();
            }
        };
        this.browseButton.addSelectionListener((SelectionListener)browseListener);
        this.specVersionLabel = new Label((Composite)this, 0);
        this.specVersionLabel.setText(Resources.specVersionLabel);
        this.specVersionLabel.setLayoutData((Object)SwtUtil.hspan((GridData)SwtUtil.gdhfill(), (int)2));
        this.specVersionTextField = new Text((Composite)this, 2048);
        this.specVersionTextField.setLayoutData((Object)SwtUtil.hspan((GridData)SwtUtil.gdhfill(), (int)2));
        this.specVersionTextField.addModifyListener(this.modifyListener);
        this.implVersionLabel = new Label((Composite)this, 0);
        this.implVersionLabel.setText(Resources.implVersionLabel);
        this.implVersionLabel.setLayoutData((Object)SwtUtil.hspan((GridData)SwtUtil.gdhfill(), (int)2));
        this.implVersionTextField = new Text((Composite)this, 2048);
        this.implVersionTextField.setLayoutData((Object)SwtUtil.hspan((GridData)SwtUtil.gdhfill(), (int)2));
        this.implVersionTextField.addModifyListener(this.modifyListener);
        this.newerVersionCheckBox = new Button((Composite)this, 32);
        this.newerVersionCheckBox.setText(Resources.allowNewerVersions);
        this.newerVersionCheckBox.setLayoutData((Object)SwtUtil.hspan((GridData)SwtUtil.gdhfill(), (int)2));
        this.refresh();
    }

    public LibraryModuleRef getLibraryModuleRef() {
        String name = this.nameTextField.getText().trim();
        Version specVersion = LibraryModuleRefPanel.version(this.specVersionTextField);
        Version implVersion = LibraryModuleRefPanel.version(this.implVersionTextField);
        boolean allowNewer = this.newerVersionCheckBox.getSelection();
        return new LibraryModuleRef(name, specVersion, implVersion, allowNewer);
    }

    public void setLibraryModuleRef(LibraryModuleRef ref) {
        Version implVersion;
        this.nameTextField.setText(ref.getName());
        Version specVersion = ref.getSpecificationVersion();
        if (specVersion != null) {
            this.specVersionTextField.setText(specVersion.toString());
        }
        if ((implVersion = ref.getImplementationVersion()) != null) {
            this.implVersionTextField.setText(implVersion.toString());
        }
        boolean allowNewer = ref.getAllowNewerVersions();
        this.newerVersionCheckBox.setSelection(allowNewer);
    }

    public boolean isValid() {
        return this.nameTextField.getText().trim().length() > 0;
    }

    public void addListener(IListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        for (IListener listener : this.listeners) {
            try {
                listener.handleEvent(null);
            }
            catch (Exception e) {
                WlsUiPlugin.log(e);
            }
        }
    }

    private void performBrowse() {
        BrowseLibraryModulesDialog dialog = new BrowseLibraryModulesDialog(this.getShell(), this.webOnly);
        if (dialog.open() == 0) {
            LibraryModule libmodule = dialog.getLibraryModule();
            String name = libmodule.getName();
            Version specVersion = libmodule.getSpecificationVersion();
            this.nameTextField.setText(name);
            if (specVersion != null) {
                this.specVersionTextField.setText(specVersion.toString());
            } else {
                this.specVersionTextField.setText("");
            }
            this.implVersionTextField.setText("");
            this.newerVersionCheckBox.setSelection(false);
            this.refresh();
        }
    }

    private void verifyNameText(VerifyEvent evt) {
        if (evt.text.length() == 1) {
            if (LibraryModuleRefPanel.isIllegalNameCharacter(evt.character)) {
                evt.doit = false;
            }
        } else {
            int illegalCharacterPosition = -1;
            int i = 0;
            int n = evt.text.length();
            while (i < n) {
                if (LibraryModuleRefPanel.isIllegalNameCharacter(evt.text.charAt(i))) {
                    illegalCharacterPosition = i;
                    break;
                }
                ++i;
            }
            if (illegalCharacterPosition != -1) {
                evt.text = evt.text.substring(0, illegalCharacterPosition);
            }
        }
    }

    private static boolean isIllegalNameCharacter(char ch) {
        return ch == '/' || ch == '\\' || ch == ':' || ch == '*' || ch == '?' || ch == '\"' || ch == '<' || ch == '>' || ch == '|';
    }

    private void refresh() {
        boolean specVersionEnabled = this.nameTextField.getText().trim().length() > 0;
        this.specVersionLabel.setEnabled(specVersionEnabled);
        this.specVersionTextField.setEnabled(specVersionEnabled);
        this.clearIfDisabled(this.specVersionTextField);
        boolean implVersionEnabled = this.specVersionTextField.getText().trim().length() > 0;
        this.implVersionLabel.setEnabled(implVersionEnabled);
        this.implVersionTextField.setEnabled(implVersionEnabled);
        this.clearIfDisabled(this.implVersionTextField);
    }

    private void clearIfDisabled(Text textfield) {
        if (!textfield.isEnabled()) {
            textfield.removeModifyListener(this.modifyListener);
            textfield.setText("");
            textfield.addModifyListener(this.modifyListener);
        }
    }

    private static Version version(Text textField) {
        String trimmed = textField.getText().trim();
        if (trimmed.length() == 0) {
            return null;
        }
        return new Version(trimmed);
    }

    private static final class Resources
    extends NLS {
        public static String nameLabel;
        public static String browseButtonLabel;
        public static String specVersionLabel;
        public static String implVersionLabel;
        public static String allowNewerVersions;

        static {
            Resources.initializeMessages((String)LibraryModuleRefPanel.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

